<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable; //added by ss
use Illuminate\Foundation\Auth\User as Authenticatable; //added by ss
use Illuminate\Database\Eloquent\SoftDeletes; //added by ss
use App\Notifications\AdminResetPasswordLink;
use App\Notifications\WebAdminResetPasswordLink;
use Illuminate\Support\Facades\Cache;
use Spatie\Permission\Traits\HasRoles;
use File;
use Route;

class Admin extends Authenticatable
{
    use HasRoles;
    use HasFactory;
    use Notifiable; //added by ss
    use SoftDeletes; //added by ss


    protected $primaryKey = 'id';

    const ACTIVE = 'Active';
    const INACTIVE = 'Inactive';
    const SUPERADMIN = 'Super-Admin';
    const SUBADMIN = 'Sub-Admin';
    const STAFF = 'Staff';
    const TABALL = "all";
    const TABSUBADMIN = "sub-admin";
    const TABSTAFF = "staff";
    const TABLENAME = "admins";
    const MALE ="Male";
    const FEMALE ="Female";
    const MALEVALUE =0;
    const FEMALEVALUE =1;

    const IMAGE_PATH = 'img/admins/';
    const THUMB_IMAGE_PATH = 'img/admins/thumb';
    const TEMP_PATH = "img/temp/";
    const THUMB_SIZE = 70;

    protected $guard_name = "Admin";

    use \Kyslik\ColumnSortable\Sortable;

    public $sortable = [ 'id', 'role_id', 'fullname', 'email', 'phone', 'status','phone','username','account_type'];


    protected $fillable = [ 'role_id','fullname', 'email', 'email_verified_at', 'phone','password', 'image', 'status', 'remember_token','username','country_code','dob','gender','address','remarks',"account_type"];

    protected $appends = [ 'phone_with_code', 'thumb_image_url', 'image_url' ];
    
    protected static function boot()
    {
        parent::boot();

        self::created(function ($model) {
            self::deleteCache($model);
        });

        self::updated(function ($model) {
            self::deleteCache($model);
        });

        self::deleted(function ($model) {
            self::deleteCache($model);
        });
    }

    private static function deleteCache($model)
    {
        Cache::forget('get-worksmiths');
    }

    public function staff_job()
    {
        return $this->hasMany('\App\Models\Job', 'staff_id', 'id');
    }

    public function staff_quotation()
    {
        return $this->hasMany('\App\Models\Quotation', 'staff_id', 'id');
    }

    // public function worksmith_job()
    // {
    //     return $this->hasMany('\App\Models\Job', 'worksmith_id', 'id');
    // }

    public function role()
    {
        return $this->belongsTo(Role::class, 'role_id', 'id');
    }

    public function sendPasswordResetNotification($token)
    {
        if(Route::currentRouteName()=='password.email'){
            $this->notify(new WebAdminResetPasswordLink($token));
        }else{
            $this->notify(new AdminResetPasswordLink($token));
        }
    }

    /**
     * Route notifications for the mail channel.
     *
     * @param  \Illuminate\Notifications\Notification  $notification
     * @return array|string
     */
    public function routeNotificationForMail($notification) 
    {
        return [$this->email => $this->fullname];
    }

    public function getThumbImageUrlAttribute()
    {
        $value = $this->attributes['image'];
        if (!empty($value) && File::exists(public_path(Self::THUMB_IMAGE_PATH).'/'.$value)){
            return asset('public/img/admins/thumb/'.$value);
        }else{
            return asset('public/img/default-placeholder.jpg');
        }
    }

    public function getImageUrlAttribute()
    {
        $value = $this->attributes['image'];
        if (!empty($value) && File::exists(public_path(Self::IMAGE_PATH) . '/' . $value)) {
            return asset('public/img/admins/' . $value);
        } else {
            return asset('public/img/default-placeholder.jpg');
        }
    }

    public static function handleBYArray()
    {
        $role_id = Role::roleByName(Role::STAFF);
        return $staff = Admin::where('role_id', $role_id)->get();
    }

    public static function getGender()
    {
        return [
            self::MALEVALUE => self::MALE,
            self::FEMALEVALUE => self::FEMALE,
        ];
    }
   
    // public function getPhoneWithCodeAttribute()
    // {
    //     // return "{$this->country_code} {$this->phone}";

    //     return isset($this->phone) ? isset($this->country_code)  ? (substr_count($this->country_code, '+') > 0) ? $this->country_code." ".$this->phone : '+'.$this->country_code." ".$this->phone : $this->phone : '-';
    // }

    public function getPhoneWithCodeAttribute()
    {
        // return "{$this->country_code ?? ''} {$this->phone}";
        return isset($this->phone) ? ($this->country_code ? $this->country_code.' '.$this->phone : $this->phone) : '-';
    }

    public static function nameById($id)
    {
        $staff =  Admin::where('id',$id)->first();
        if($staff->exists()){
            $name = $staff->fullname;
        }
        return  $name;
    }


}
