<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class QuotationPDFMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $mailData; 

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($mailData) 
    {
        $this->mailData = $mailData;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        // https://laravel.com/docs/8.x/mail
        $this->markdown('emails.quotationPDFMail')
            ->with(
                array(
                    'mailData' => $this->mailData
                )
            )
            // ->attachData($this->mailData['pdf'], 'quotation.pdf', [
            //     'mime' => 'application/pdf',
            // ]); // $this->pdf->output()
            ->attachData($this->mailData['quotationPDF'], 'quotation.pdf', [
                'mime' => 'application/pdf',
            ])->attachData($this->mailData['orderVoucherPDF'], 'order_voucher.pdf', [
                'mime' => 'application/pdf',
            ]); // ; // $this->pdf->output()
    }
}
