<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class QuotationAndInvoicePDFMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $mailData; 

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($mailData) 
    {
        $this->mailData = $mailData;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        // https://laravel.com/docs/8.x/mail
        $this->markdown('emails.quotationAndInvoicePDFMail')
            ->with(
                array(
                    'mailData' => $this->mailData
                )
            )
            ->attachData($this->mailData['quotationPDF'], 'quotation.pdf', [
                'mime' => 'application/pdf',
            ])->attachData($this->mailData['orderVoucherPDF'], 'order_voucher.pdf', [
                'mime' => 'application/pdf',
            ])->attachData($this->mailData['invoicePDF'], 'invoice.pdf', [
                'mime' => 'application/pdf',
            ]); 
            // invoice.pdf -> new name given to pdf  
    }
}
