<?php

namespace App\Http\Requests\Jobs;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Http\Response;

class JobsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function failedValidation(Validator $validator): void
    {
        $errors = $validator->errors();

        throw new HttpResponseException(response()->json([
            'status' => 0,
            'errors' => $errors,

        ], Response::HTTP_OK));
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->id) {
            $job = [
                'customer_phone' => 'required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15',
                'customer_name'  =>  "required|string|max:50|regex:/^[a-zA-Z ]+$/",
                'customer_email' => "required|email|max:190",
            ];
        } else {
            $job = [
                'customer_phone' => 'required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15',
                'customer_name'  =>  "required|string|max:50|regex:/^[a-zA-Z ]+$/",
                'customer_email' => "required|email|max:190",
            ];
        }
        return $job;
    }

    public function messages()
    {
        return [
            'category_id.required' => 'Category field is required.',
            'gold_color_id.required' => 'Gold color field is required.',
        ];
    }
}
