<?php

namespace App\Http\Requests\Jobs;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Http\Response;

class JobItemsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function failedValidation(Validator $validator): void
    {
        $errors = $validator->errors();

        throw new HttpResponseException(response()->json([
            'status' => 0,
            'errors' => $errors,

        ], Response::HTTP_OK));
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        // dd($this->toArray());
        if ($this->id) {
            $job = [
                'category_id' => 'required|integer|not_in:0',
                'description' => 'nullable|string',
                'gold_color_id' => 'required|integer|not_in:0',
                'material' => 'required|string|max:255',
                'quantity' => 'required|integer|not_in:0',
                'customer_recieved' => 'nullable',
                'job.*.Bespoke.jewelleries.*.stock_no'   =>"nullable|string",
                'job.*.Bespoke.jewelleries.*.weight'     =>"nullable|numeric|required_with:qut.*.Bespoke.jewelleries.*.stock_no",
                'job.*.Bespoke.jewelleries.*.unit_price' =>"nullable|numeric|required_with:qut.*.Bespoke.jewelleries.*.stock_no",
                'job.*.Bespoke.jewelleries.*.price'      =>"nullable|numeric|required_with:qut.*.Bespoke.jewelleries.*.stock_no",
            ];
        } else {
            $job = [
                'category_id' => 'required|integer|not_in:0',
                'description' => 'nullable|string',
                'gold_color_id' => 'required|integer|not_in:0',
                'material' => 'required|string|max:255',
                'quantity' => 'required|integer|not_in:0',
                'customer_recieved' => 'nullable',
                'job.*.Bespoke.jewelleries.*.stock_no'   =>"nullable|string",
                'job.*.Bespoke.jewelleries.*.weight'     =>"nullable|numeric|required_with:qut.*.Bespoke.jewelleries.*.stock_no",
                'job.*.Bespoke.jewelleries.*.unit_price' =>"nullable|numeric|required_with:qut.*.Bespoke.jewelleries.*.stock_no",
                'job.*.Bespoke.jewelleries.*.price'      =>"nullable|numeric|required_with:qut.*.Bespoke.jewelleries.*.stock_no",
            ];
        }
        return $job;
    }

    public function messages()
    {
        return [
            'category_id.required' => 'Category field is required.',
            'gold_color_id.required' => 'Gold color field is required.',
            "job.*.Bespoke.jewelleries.*.weight.numeric" => 'The weight must be a number.',
            "job.*.Bespoke.jewelleries.*.unit_price.numeric" => 'The unit price must be a number.',
            "job.*.Bespoke.jewelleries.*.price.numeric" => 'The price must be a number.',
            "job.*.Bespoke.jewelleries.*.price.required_with"      => 'The price field is required.',
            "job.*.Bespoke.jewelleries.*.weight.required_with"     => 'The weight field is required.',
            "job.*.Bespoke.jewelleries.*.unit_price.required_with" => 'The unit price field is required.',
        ];
    }
}
