<?php

namespace App\Http\Requests\Quotations;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Http\Response;

class QuotationsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function failedValidation(Validator $validator): void
    {
        $errors = $validator->errors();

        throw new HttpResponseException(response()->json([
            'status' => 0,
            'errors' => $errors,

        ], Response::HTTP_OK));
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->id) {
            $quotations = [
                'customer_phone' => 'required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15',
                'customer_name'  =>  "required|string|max:50|regex:/^[a-zA-Z ]+$/",
                'customer_email' => "required|email|max:190",
            ];
        } else {
            $quotations = [
                'customer_phone' => 'required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15',
                'customer_name'  =>  "required|string|max:50|regex:/^[a-zA-Z ]+$/",
                'customer_email' => "required|email|max:190",
            ];
        }
        return $quotations;
    }

    public function messages()
    {
        return [
        
        ];
    }
}
