<?php

namespace App\Http\Requests\Quotations;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Http\Response;

class QuotationItemsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function failedValidation(Validator $validator): void
    {
        $errors = $validator->errors();

        throw new HttpResponseException(response()->json([
            'status' => 0,
            'errors' => $errors,

        ], Response::HTTP_OK));
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->id) {
            $quotations = [
                'category_id' => 'required|integer|not_in:0',
                'description' => 'nullable|string',
                'gold_color_id' => 'required|integer|not_in:0',
                'material' => 'required|string|max:255',
                'quantity' => 'required|integer|not_in:0',
                // 'drawing_textarea_base64' => 'nullable',
            ];
        } else {
            $quotations = [
                'category_id' => 'required|integer|not_in:0',
                'description' => 'nullable|string',
                'gold_color_id' => 'required|integer|not_in:0',
                'material' => 'required|string|max:255',
                'quantity' => 'required|integer|not_in:0',
            ];
        }
        return $quotations;
    }

    public function messages()
    {
        return [
            'category_id.required' => 'Category field is required.',
            'gold_color_id.required' => 'Gold color field is required.',
        ];
    }
}
