<?php

namespace App\Http\Requests\Quotations;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Http\Response;

class CreateInvoicesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function failedValidation(Validator $validator): void
    {
        $errors = $validator->errors();

        throw new HttpResponseException(response()->json([
            'status' => 0,
            'title' => 'Error',
            'errors' => $errors->first(),

        ], Response::HTTP_OK));
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'qut_item_ids' => 'required',
            'quotation_id'  => 'required|integer|not_in:0',   
        ];
    }

    public function messages()
    {
        return [
            'qut_item_ids.required' => 'Please check atleast one checkbox.',
        ];
    }
}
