<?php

namespace App\Http\Requests\Invoices;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Http\Response;
use App\Models\Invoice;

class UpdatePaymentsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function failedValidation(Validator $validator): void
    {
        $errors = $validator->errors();

        throw new HttpResponseException(response()->json([
            'status' => 0,
            'errors' => $errors,

        ], Response::HTTP_OK));
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
   
    public function rules()
    {
        $record = Invoice::findOrFail($this->invoice_id);
        $total = $record->total;

        return [
            'invoice_id'  => 'required|integer|not_in:0',
            'paid_amount' => 'required|numeric|not_in:0|max:'.$total,
        ];
    }

    public function messages()
    {
        return [
            'paid_amount.required' => 'The amount to deposit field is required.',
            'paid_amount.numeric' => 'The amount to deposit must be a number.',
            'paid_amount.not_in' => 'The amount to deposit must be a greater than 0.',
            'paid_amount.max' =>  'The paid amount must not be greater than total amount.',
        ];
    }
}
