<?php

namespace App\Http\Requests\Invoices;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Http\Response;

class InvoicesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function failedValidation(Validator $validator): void
    {
        $errors = $validator->errors();

        throw new HttpResponseException(response()->json([
            'status' => 0,
            'errors' => $errors,

        ], Response::HTTP_OK));
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->id) {
            $invoice = [
                'customer_phone' => 'required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15',
                'customer_name'  =>  "required|string|max:50|regex:/^[a-zA-Z ]+$/",
                'customer_email' => "required|email|max:190",
            ];
        }else{    
            $invoice = [
                'customer_phone' => 'required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15',
                'customer_name'  =>  "required|string|max:50|regex:/^[a-zA-Z ]+$/",
                'customer_email' => "required|email|max:190",
            ];
        }
        return  $invoice;
    }
}
