<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class WorksmithsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->id) {
            $worksmith = [
                'fullname' => 'required|string|min:3|max:50|regex:/^[a-zA-Z ]+$/',
                'email'    => 'required|email:rfc,dns,filter|unique:worksmiths,email,'.$this->id,
                'phone'    => "required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15|unique:worksmiths,phone,".$this->id,
                'image'    => 'nullable',
                'dob'      => 'nullable|date|before:15 years ago',
                'gender'   => 'required|in:0,1',
                'address'  => 'nullable|max:255',
                'remarks'  => 'nullable|max:255',
            ];
        } else {
            $worksmith = [
                'fullname' => 'required|min:3|max:50|regex:/^[a-zA-Z ]+$/',
                'email'    => 'required|email:rfc,dns,filter|unique:worksmiths,email,'.$this->id,
                'phone'    => "required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15|unique:worksmiths,phone,".$this->id,
                'image'    => 'nullable',
                'dob'      => 'nullable|date|before:15 years ago',
                'gender'   => 'required|in:0,1',
                'address'  => 'nullable|max:255',
                'remarks'  => 'nullable|max:255',
            ];
        }
        return $worksmith;
    }
    public function messages()
    {
        return [
            // 'role_id.required_if' => 'The Role field is required.',
        ];
    }
}
