<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class TypesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if($this->id){
            $type = [
                'name'      => 'required|string|unique:types,name,'.$this->id.',id',
                'status'    => 'nullable|string',
            ];
        } else {
            $type = [
                'name'      => 'required|string|unique:types,name,'.$this->id.',id', 
                'status'    => 'nullable|string',
            ];
        }
        return $type;
    }

    public function messages()
    {
        return [
            'name.required' => 'The type field is required.',
        ];
    }
}
