<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class StaffsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->id) {

            $staffs = [
                'role_id'      => "nullable|required_if:account_type,==,Staff|integer|not_in:0",
                'fullname'     => 'nullable|string|min:3|max:50|regex:/^[a-zA-Z ]+$/',
                'email'        => 'required|email:rfc,dns,filter|unique:admins,email,'.$this->id,
                'password'     => 'nullable|string|min:8|confirmed',
                'phone'        => "required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15|unique:admins,phone,".$this->id,
                'image'        => 'nullable',
                'username'     => 'required|string|min:3|unique:admins,username,'.$this->id,
                'country_code' => 'nullable',
                'dob'          => 'nullable|date|before:15 years ago',
                'gender'       => 'required|in:0,1',
                'address'      => 'nullable|max:255',
                'remarks'      => 'nullable|max:255',
                'account_type' => 'nullable',
            ];
        } else {
            $staffs = [
                'role_id'      => "nullable|integer|not_in:0|required_if:account_type,==,Staff",
                'fullname'     => 'required|min:3|max:50|regex:/^[a-zA-Z ]+$/',
                'email'        => 'required|email:rfc,dns,filter|unique:admins,email,' . $this->id,
                'password'     => 'required|string|min:8|confirmed',
                'phone'    => "required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15|unique:admins,phone,".$this->id,
                'image'        => 'nullable',
                'username'     => 'required|string|min:3|unique:admins,username,' .$this->id,
                'country_code' => 'nullable',
                'dob'          => 'nullable|date|before:15 years ago',
                'gender'       => 'required|in:0,1',
                'address'      => 'nullable|max:255',
                'remarks'      => 'nullable|max:255',
                'account_type' => 'nullable',
            ];
        }
        return $staffs;
    }
    public function messages()
    {
        return [
            'role_id.required_if' => 'The Role field is required.',
        ];
    }
}
