<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class SizesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if($this->id){
            $sizes = [
                'name'        => 'required|numeric|min:0|unique:sizes,name,'.$this->id.',id,category_id,'.$this->category_id, 
                'category_id' => 'required|integer|not_in:0',
                'status'      => 'nullable|string',
            ];
        } else {
            $sizes = [
                'name'        => 'required|numeric|min:0|unique:sizes,name,NULL,id,category_id,'.$this->category_id, 
                'category_id' => 'required|integer|not_in:0',
                'status'      => 'nullable|string',
            ];
        }
        return $sizes;
    }

    public function messages()
    {
        return [
            'name.required'        => 'The size field is required.',
            'category_id.required' => 'The category field is required.'
        ];
    }
}
