<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class ShopSettingsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'email'            => 'required|email:rfc,dns,filter|max:255',
            'phone'            => 'required|max:18',
            'address_line1'    => 'required|string|max:255',
            'address_line2'    => 'required|string|max:255',
            'print_port'       => 'required|string',
            'print_ip_address' => 'required|string', 
        ];
    }

    public function messages()
    {
        return [
            //
        ];
    }
}
