<?php

namespace App\Http\Requests\Admin\Quotations;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Http\Response;
use App\Models\QuotationItem;

class QuotationItemsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function failedValidation(Validator $validator): void
    {
        $errors = $validator->errors();

        throw new HttpResponseException(response()->json([
            'status' => 0,
            'errors' => $errors,

        ], Response::HTTP_OK));
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $type  = $this->type; 
        
        if($type == QuotationItem::BESPOKE){
            if ($this->id) {
                $quotation  = [
                    'quotation_id'                           => "nullable",
                    'category_id'                            => "required|integer|not_in:0",
                    'description'                            => "nullable|string",
                    'gold_color_id'                          => "requiredinteger|not_in:0",
                    'size'                                   => "nullable|numeric|between:0.01,99999.99",
                    // 'is_sample_provided'                     => "nullable",
                    // 'sample_description'                     => "nullable|string",
                    'is_sample_provided'                     => "nullable|in:".QuotationItem::ZERO.",".QuotationItem::ONE,
                    'sample_description'                     => "required_if:is_sample_provided,".QuotationItem::ONE,
                    'gold_cost'                              => "required|numeric",
                    'gold_weight'                            =>"required|numeric|between:0.01,9999999999.99",
                    'craftsmanship_cost'                     => "required|numeric",
                    'polishing'                              => "required|numeric",
                    'setting_cost'                           => "required|numeric",
                    'earing_pin'                             => "nullable|numeric|between:0.01,9999999999.99",
                    'backing_cost'                           => "nullable|numeric",
                    'backing_type'                           => "nullable",
                    'backing_size'                           => "nullable|numeric|between:0.01,9999999999.99",
                    'backing_quantity'                       => "nullable|integer|between:0.01,9999999999.99",
                    'claw'                                   => "required",
                    'drawing_textarea_base64'                => "nullable",
                    'worksmith_id'                           => "nullable|integer|not_in:0",
                    'qut.*.Bespoke.jewelleries.*.stock_no'   => "nullable|string",
                    'qut.*.Bespoke.jewelleries.*.weight'     =>"nullable|numeric|required_with:qut.*.Bespoke.jewelleries.*.stock_no",
                    'qut.*.Bespoke.jewelleries.*.unit_price' =>"nullable|numeric|required_with:qut.*.Bespoke.jewelleries.*.stock_no",
                    'qut.*.Bespoke.jewelleries.*.price'      =>"nullable|numeric|required_with:qut.*.Bespoke.jewelleries.*.stock_no",
                 ];
             } else {
                $quotation = [
                    'category_id'                            => "required",
                    'description'                            => "nullable|string",
                    'gold_color_id'                          => "required|integer|not_in:0",
                    'size'                                   => "nullable|numeric|between:0.01,99999.99",
                    // 'is_sample_provided'                     => "nullable",
                    // 'sample_description'                     => "nullable|string",
                    'is_sample_provided'                     => "nullable|in:".QuotationItem::ZERO.",".QuotationItem::ONE,
                    'sample_description'                     => "required_if:is_sample_provided,".QuotationItem::ONE,
                    'gold_cost'                              => "required|numeric",
                    'gold_weight'                            =>"required|numeric|between:0.01,9999999999.99",
                    'craftsmanship_cost'                     => "required|numeric",
                    'polishing'                              => "required|numeric",
                    'setting_cost'                           => "required|numeric",
                    'earing_pin'                             => "nullable|numeric|between:0.01,9999999999.99",
                    'backing_cost'                           => "nullable|numeric",
                    'backing_type'                           => "nullable",
                    'backing_size'                           => "nullable|numeric|between:0.01,9999999999.99",
                    'backing_quantity'                       => "nullable|integer|between:0.01,9999999999.99",
                    'claw'                                   => "required",
                    'drawing_textarea_base64'                => "nullable",
                    'images'                                 => "nullable",
                    'worksmith_id'                           => "nullable|integer|not_in:0",
                    'qut.*.Bespoke.jewelleries.*.stock_no'   =>"nullable|string",
                    'qut.*.Bespoke.jewelleries.*.weight'     =>"nullable|numeric|required_with:qut.*.Bespoke.jewelleries.*.stock_no",
                    'qut.*.Bespoke.jewelleries.*.unit_price' =>"nullable|numeric|required_with:qut.*.Bespoke.jewelleries.*.stock_no",
                    'qut.*.Bespoke.jewelleries.*.price'      =>"nullable|numeric|required_with:qut.*.Bespoke.jewelleries.*.stock_no",
                ];
            }
        } else{
       
            if ($this->id) {

                $quotation = [
                    'quotation_id'                               => "nullable|integer|not_in:0",
                    'category_id'                                => "required|integer|not_in:0",
                    'description'                                => "nullable|string|min:10",
                    'drawing_textarea_base64'                    => "nullable",
                    'images'                                     => "nullable",
                    'qut.*.Repair.jewelleries.*.stock_no'        =>"nullable|string",
                    'qut.*.Repair.jewelleries.*.weight'          =>"nullable|numeric|required_with:qut.*.Repair.jewelleries.*.weight",
                    'qut.*.Repair.jewelleries.*.unit_price'      =>"nullable|numeric|required_with:qut.*.Repair.jewelleries.*.unit_price",
                    'qut.*.Repair.jewelleries.*.price'           =>"nullable|numeric|required_with:qut.*.Repair.jewelleries.*.price",

                ];

            } else{

                $quotation = [
                    'quotation_id'                               => "nullable|integer|not_in:0",
                    'category_id'                                => "required|integer|not_in:0",
                    'description'                                => "nullable|string|min:10",
                    'drawing_textarea_base64'                    => "nullable",
                    'images'                                     => "nullable",
                    'qut.*.Repair.jewelleries.*.stock_no'        =>"nullable|string",
                    'qut.*.Repair.jewelleries.*.weight'          =>"nullable|numeric|required_with:qut.*.Repair.jewelleries.*.weight",
                    'qut.*.Repair.jewelleries.*.unit_price'      =>"nullable|numeric|required_with:qut.*.Repair.jewelleries.*.unit_price",
                    'qut.*.Repair.jewelleries.*.price'           =>"nullable|numeric|required_with:qut.*.Repair.jewelleries.*.price",

                ];
            }

        }
        return $quotation;
    }

    public function messages()
    {
        
     $type  = $this->type;
    return  [
            'category_id.required' => 'The Category field is required.',
            'gold_color_id.required' => 'Gold color field is required.',
            // "qut.*.$type.jewelleries.*.stock_no.max" => 'The stock no. must not be greater than 6 characters.',
            "qut.*.$type.jewelleries.*.weight.numeric" => 'The weight must be a number.',
            "qut.*.$type.jewelleries.*.unit_price.numeric" => 'The unit price must be a number.',
            "qut.*.$type.jewelleries.*.price.numeric" => 'The price must be a number.',
            // "qut.*.$type.jewelleries.*.weight.between" => 'The weight must be between 0.01 and 9999999999.99.',
            // "qut.*.$type.jewelleries.*.unit_price.between" => 'The unit price must be between 0.01 and 9999999999.99.',
            // "qut.*.$type.jewelleries.*.price.between" => 'The price must be between 0.01 and 9999999999.99.',
            "qut.*.$type.jewelleries.*.price.required_with"      => 'The price field is required.',
            "qut.*.$type.jewelleries.*.weight.required_with"     => 'The weight field is required.',
            "qut.*.$type.jewelleries.*.unit_price.required_with" => 'The unit price field is required.',
        ];
    }
}
