<?php 
namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Auth;

class ProfileUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'fullname'     => 'required|string|max:50',
            'email'        => 'required|email:rfc,dns,filter|max:255|unique:admins,email,'.Auth::guard('admin')->user()->id.',id',
            'username'     => 'required|unique:admins,username,' .Auth::guard('admin')->user()->id.',id',
            'phone'        => "required|regex:/^([0-9\s\-\+\(\)]*)$/|max:14|unique:admins,phone,".Auth::guard('admin')->user()->id.',id',
            'country_code' => 'nullable',
            'dob'          => 'nullable|date|before:15 years ago',
            'gender'       => 'required|in:0,1',
        ];
    }
}
