<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class PriceSettingsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'gst_percent' => 'required|numeric|between:0.01,99.99',
            'usd_unit'    => 'required|numeric|between:0.01,999.99',
            'hkd_unit'    => 'required|numeric|between:0.01,999.99',
        ];
    }

    public function messages()
    {
        return [
            //
        ];
    }
}
