<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class MaterialsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if($this->id){
            $materials = [
                'name'      => 'required|string|unique:materials,name,'.$this->id.',id',
                'status'    => 'nullable|string',
                'material_unit_id' => 'required',
                'quantity' => 'required|numeric|integer|gt:0',
            ];
        } else {
            $materials = [
                'name'      => 'required|string|unique:materials,name,'.$this->id.',id', 
                'status'    => 'nullable|string',
                'material_unit_id' => 'required',
                'quantity' => 'required|numeric|integer|gt:0',
            ];
        }
        return $materials;
    }

    public function messages()
    {
        return [
            'name.required' => 'The material field is required.',
            'material_unit_id.required' => 'The material unit field is required.',
        ];
    }
}
