<?php

namespace App\Http\Requests\Admin\Jobs;

use App\Models\JobType;
use Illuminate\Foundation\Http\FormRequest;

class JobReviewCostsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $typeId = 0;
        if(JobType::BESPOKE == JobType::typeById($this->type_id)){
            $typeId = JobType::getTypeIdByName(JobType::BESPOKE);
        }


        return [
            'job_id'              => "nullable|integer|not_in:0",
            'item_code'           => "required|unique:jobs,item_code,".$this->job_id,
            'date'                => "required|date",
            'estimate_completion' => "required|date",
            'type_id'             => "required|integer|not_in:0",
            'gold_cost'           => "nullable|numeric",
            'craftsmanship_cost'  => "nullable|numeric",
            'polishing'           => "nullable|numeric",
            'setting_cost'        => "nullable|numeric",
            'backing_cost'        => "nullable|numeric",
            'gst_percent'         => "nullable|numeric",
            'gst_amount'          => "nullable|numeric",
            'mark_up'             => "required|numeric|between:0.01,9999999999.99",
            'mark_up_usd'         => "required|numeric|between:0.01,9999999999.99",
            'mark_up_hkd'         => "required|numeric|between:0.01,9999999999.99",
            'usd_exchange_rate'   => "required|numeric|between:0.01,999.99",
            'hkd_exchange_rate'   => "required|numeric|between:0.01,999.99",
            'sub_total'           => "nullable|numeric",
            'total'               => "nullable|numeric",
            'jewelleries.*.price' => "nullable|numeric",
        ];

    }

    public function messages()
    {
        return [
            'jewelleries.*.price.numeric'   => 'The price must be a number.',
            // 'jewelleries.*.price.between'   => 'The price must be between 0.01 and 9999999999.99.',
        ];
    }
}

