<?php

namespace App\Http\Requests\Admin\Jobs;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Jewellery;
use App\Models\JobType;

class JobRequests extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *c
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {

        // $typeId = 0;
        if(JobType::BESPOKE == JobType::typeById($this->type_id)){
            // $typeId = JobType::getTypeIdByName(JobType::BESPOKE);

            if ($this->id) {
                $job = [
                    'job_id'                   => "nullable|integer|not_in:0",
                    'item_code'                => "required|unique:jobs,item_code,".$this->id,
                    'date'                     => "required|date",
                    'estimate_completion'      => "required|date",
                    'type_id'                  => "required|integer|not_in:0",
                    'description'              => "nullable|string",
                    'category_id'              => "required|integer|not_in:0",
                    'gold_color_id'            => "required|integer|not_in:0",
                    'size'                     => "nullable|numeric|between:0.01,99999.99",
                    'is_sample_provided'       => "nullable|in:".Jewellery::ZERO.",".Jewellery::ONE,
                    'sample_description'       => "required_if:is_sample_provided,".Jewellery::ONE,
                    'gold_cost'                => "required|numeric",
                    'gold_weight'              => "required|numeric|between:0.01,9999999999.99",
                    'workmanship_cost'         => "required|numeric",
                    'pollising_cost'           => "required|numeric",
                    'setting_cost'             => "required|numeric",
                    'earing_pin'               => "nullable|numeric|between:0.01,9999999999.99",
                    'backing_cost'             => "nullable|numeric",
                    'backing_type'             => "nullable",
                    'backing_size'             => "nullable|numeric|between:0.01,9999999999.99",
                    'backing_quantity'         => "nullable|integer|between:0.01,9999999999.99",
                    'claw'                     => "required|string|in:".Jewellery::EAGLE.",".Jewellery::ROUND.",".Jewellery::SQUARE.",".Jewellery::NO_CLAW,
                    'jewelleries.*.stock_no'   => "nullable|string",
                    'jewelleries.*.weight'     => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'jewelleries.*.unit_price' => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'jewelleries.*.price'      => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'staff_id'                 => "required|integer|not_in:0",
                    'customer_phone'           => "required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15",
                    'customer_name'            =>  "required|string|max:50|regex:/^[a-zA-Z ]+$/",
                    'customer_email'           => "required|email|max:190",
                    'drawing_textarea_base64'  => "nullable",
                    'images'                   => "nullable",
                    'worksmith_id'             => "nullable|integer|not_in:0",
                ];
            } else {
                $job = [
                    'job_id'                   => "nullable|integer|not_in:0",
                    'date'                     => "required|date",
                    'estimate_completion'      => "required|date",
                    'type_id'                  => "required|integer|not_in:0",
                    'description'              => "nullable|string",
                    'category_id'              => "required|integer|not_in:0",
                    'gold_color_id'            => "required|integer|not_in:0",
                    'size'                     => "nullable|numeric|between:0.01,99999.99",
                    'is_sample_provided'       => "nullable|in:".Jewellery::ZERO.",".Jewellery::ONE,
                    'sample_description'       => "required_if:is_sample_provided,".Jewellery::ONE,
                    'gold_cost'                => "required|numeric",
                    'gold_weight'              => "required|numeric|between:0.01,9999999999.99",
                    'workmanship_cost'         => "required|numeric",
                    'pollising_cost'           => "required|numeric",
                    'setting_cost'             => "required|numeric",
                    'earing_pin'               => "nullable|numeric|between:0.01,9999999999.99",
                    'backing_cost'             => "nullable|numeric",
                    'backing_type'             => "nullable",
                    'backing_size'             => "nullable|numeric|between:0.01,9999999999.99",
                    'backing_quantity'         => "nullable|integer|between:0.01,9999999999.99",
                    'claw'                     => "required|string|in:".Jewellery::EAGLE.",".Jewellery::ROUND.",".Jewellery::SQUARE.",".Jewellery::NO_CLAW,
                    'jewelleries.*.stock_no'   => "nullable|string",
                    'jewelleries.*.weight'     => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'jewelleries.*.unit_price' => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'jewelleries.*.price'      => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'staff_id'                 => "required|integer|not_in:0",
                    'customer_phone'           => "required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15",
                    'customer_name'            =>  "required|string|max:50|regex:/^[a-zA-Z ]+$/",
                    'customer_email'           => "required|email|max:190",
                    'drawing_textarea_base64'  => "nullable",
                    'images'                   => "nullable",
                    'worksmith_id'             => "nullable|integer|not_in:0",
                ];
            }
        }else{
            if ($this->id) {
                $job = [
                    'job_id'                         => "nullable|integer|not_in:0",
                    'item_code'                      => "required|unique:jobs,item_code,".$this->id,
                    'date'                           => "required|date",
                    'estimate_completion'            => "required|date",
                    'type_id'                        => "required|integer|not_in:0",
                    'description'                    => "nullable|string",
                    'category_id'                    => "required|integer|not_in:0",
                    'jewelleries.*.stock_no'         => "nullable|string",
                    'jewelleries.*.weight'           => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'jewelleries.*.unit_price'       => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'jewelleries.*.price'            => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'staff_id'                       => "required|integer|not_in:0",
                    'customer_phone'                 => "required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15",
                    'customer_name'                  =>  "required|string|max:50|regex:/^[a-zA-Z ]+$/",
                    'customer_email'                 => "required|email|max:190",
                    'customer_signature'             => "nullable",
                    'sales_representative_signature' => "nullable",
                    'drawing_textarea_base64'        => "nullable",
                    'images'                         => "nullable",
                    'worksmith_id'                   => "nullable|integer|not_in:0",
                ];
            } else {
                $job = [
                    'job_id'                         => "nullable|integer|not_in:0",
                    'date'                           => "required|date",
                    'estimate_completion'            => "required|date",
                    'type_id'                        => "required|integer|not_in:0",
                    'description'                    => "nullable|string",
                    'category_id'                    => "required|integer|not_in:0",
                    'jewelleries.*.stock_no'         => "nullable|string",
                    'jewelleries.*.weight'           => "nullable|numeric|between:0.01,9999999999.99|required_with:jewelleries.*.stock_no",
                    'jewelleries.*.unit_price'       => "nullable|numeric|between:0.01,9999999999.99|required_with:jewelleries.*.stock_no",
                    'jewelleries.*.price'            => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'staff_id'                       => "required|integer|not_in:0",
                    'customer_phone'                 => "required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15",
                    'customer_name'                  =>  "required|string|max:50|regex:/^[a-zA-Z ]+$/",
                    'customer_email'                 => "required|email|max:190",
                    'customer_signature'             => "nullable",
                    'sales_representative_signature' => "nullable",
                    'drawing_textarea_base64'        => "nullable",
                    'images'                         => "nullable",
                    'worksmith_id'                   => "nullable|integer|not_in:0",
                ];
            }
        }

        // if ($this->id) {
        //     $job = [
        //         'job_id'                           => "nullable|integer|not_in:0",
        //         'date'                             => "required|date",
        //         'estimate_completion'              => "required|date",
        //         'type_id'                          => "required|integer|not_in:0",
        //         'description'                      => "required|string|min:10",
        //         'category_id'                      => "required|integer|not_in:0",
        //         'gold_color_id'                    => "nullable|required_if:type_id,==,$typeId",
        //         'size'                             => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,99999.99",
        //         'is_sample_provided'               => "nullable|required_if:type_id,==,$typeId",
        //         'sample_description'               => "sometimes|min:10|required_if:type_id,==,$typeId",
        //         'gold_cost'                        => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
        //         'gold_weight'                      => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
        //         'workmanship_cost'                 => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
        //         'pollising_cost'                   => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
        //         'setting_cost'                     => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
        //         'earing_pin'                       => "nullable|numeric|between:0.01,9999999999.99",
        //         'backing_cost'                     => "nullable|numeric|between:0.01,9999999999.99",
        //         'backing_type'                     => "nullable",
        //         'backing_size'                     => "nullable|numeric|between:0.01,9999999999.99",
        //         'backing_quantity'                 => "nullable|integer|between:0.01,9999999999.99",
        //         'claw'                             => "nullable|required_if:type_id,==,$typeId",
        //         'jewelleries.*.stock_no'           => "nullable|string|max:6",
        //         'jewelleries.*.weight'             => "nullable|numeric|between:0.01,9999999999.99|required_with:jewelleries.*.stock_no",
        //         'jewelleries.*.unit_price'         => "nullable|numeric|between:0.01,9999999999.99|required_with:jewelleries.*.stock_no",
        //         'jewelleries.*.price'              => "nullable|numeric|between:0.01,9999999999.99|required_with:jewelleries.*.stock_no",
        //         'staff_id'                         => "required|integer|not_in:0",
        //         'customer_phone'                   => 'required|regex:/^([0-9\s\-\+\(\)]*)$/|min:10|max:15',
        //         'customer_name'                    =>  "required|string|max:50|regex:/^[a-zA-Z ]+$/",
        //         'customer_email'                   => "required|email:rfc,dns,filter|max:190",
        //         'customer_signature'               => "nullable",
        //         'sales_representative_signature'   => "nullable",
        //         'drawing_textarea_base64'          => "nullable",
        //         'images'                           => "nullable",
        //         'worksmith_id'                     => "nullable|integer|not_in:0",
        //     ];
        // } else {
        //     $job = [
        //         'date'                            => "required|date",
        //         'estimate_completion'             => "required|date",
        //         'type_id'                         => "required|integer|not_in:0",
        //         'description'                     => "required",
        //         'category_id'                     => "required|integer|not_in:0",
        //         'gold_color_id'                   => "nullable|integer|not_in:0|required_if:type_id,==,$typeId",
        //         'size'                            => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,99999.99",
        //         'is_sample_provided'              => "nullable|required_if:type_id,==,$typeId",
        //         'sample_description'              => "nullable|min:10|required_if:type_id,==,$typeId",
        //         'gold_cost'                       => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
        //         'gold_weight'                     =>"nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
        //         'workmanship_cost'                => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
        //         'pollising_cost'                  => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
        //         'setting_cost'                    => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
        //         'earing_pin'                      => "nullable|numeric|between:0.01,9999999999.99",
        //         'backing_cost'                    => "nullable|numeric|between:0.01,9999999999.99",
        //         'backing_type'                    => "nullable",
        //         'backing_size'                    => "nullable|numeric|between:0.01,9999999999.99",
        //         'backing_quantity'                => "nullable|integer|between:0.01,9999999999.99",
        //         'claw'                            => "nullable|required_if:type_id,==,$typeId",
        //         'jewelleries.*.stock_no'          => "nullable|string|max:6",
        //         'jewelleries.*.weight'            => "nullable|numeric|between:0.01,9999999999.99|required_with:jewelleries.*.stock_no",
        //         'jewelleries.*.unit_price'        => "nullable|numeric|between:0.01,9999999999.99|required_with:jewelleries.*.stock_no",
        //         'jewelleries.*.price'             => "nullable|numeric|between:0.01,9999999999.99|required_with:jewelleries.*.stock_no",
        //         'staff_id'                        => "required|integer|not_in:0",
        //         'customer_phone'                  => 'required|regex:/^([0-9\s\-\+\(\)]*)$/|min:10|max:15',
        //         'customer_name'                   => "required|max:30|regex:/^[a-zA-Z ]+$/",
        //         'customer_email'                  => "required|email:rfc,dns,filter|max:190",
        //         'customer_signature'              => "nullable",
        //         'sales_representative_signature'  => "nullable",
        //         'drawing_textarea_base64'         => "nullable",
        //         'images'                          => "nullable",
        //         'worksmith_id'                    => "nullable|integer|not_in:0",
        //     ];
        // }
        return $job;
    }

    public function messages()
    {
        return [
            'category_id.required'                   => 'The Category field is required.',
            'type_id.required'                       => 'The Type field is required.',
            'gold_color_id.required_if'              => 'Gold color field is required.',
            // 'size.required_if'                       => 'Size field is required.',
            // 'gold_cost.required_if'                  => 'Gold cost field is required.',
            // 'gold_weight.required_if'                => 'Gold weight field is required.',
            // 'workmanship_cost.required_if'           => 'Workmanship field is required.',
            // 'pollising_cost.required_if'             => 'Pollising cost field is required.',
            // 'setting_cost.required_if'               => 'Setting cost field is required.',
            'sample_description.required_if'         => 'The sample description field is required when is sample provided is Yes.',
            // 'claw.required_if'                       => 'Claw field is required.',
            'staff_id.required'                      => 'Staff field is required.',
            // 'jewelleries.*.stock_no.max'             => 'The stock no. must not be greater than 6 characters.',
            'jewelleries.*.weight.numeric'           => 'The weight must be a number.',
            'jewelleries.*.unit_price.numeric'       => 'The unit price must be a number.',
            'jewelleries.*.price.numeric'            => 'The price must be a number.',
            // 'jewelleries.*.weight.between'           => 'The weight must be between 0.01 and 9999999999.99.',
            // 'jewelleries.*.unit_price.between'       => 'The unit price must be between 0.01 and 9999999999.99.',
            // 'jewelleries.*.price.between'            => 'The price must be between 0.01 and 9999999999.99.',
            'jewelleries.*.price.required_with'      => 'The price field is required.',
            'jewelleries.*.weight.required_with'     => 'The weight field is required.',
            'jewelleries.*.unit_price.required_with' => 'The unit price field is required.',
        ];
    }


    /**
     * Prepare the data for validation.
     *
     * @return void
     */
    protected function prepareForValidation()
    {
        $newRequestData = [];
        $notInBespokeArr = [ 'customer_signature', 'sales_representative_signature' ];

        $notInRepairArr = [ 'earing_pin', 'gold_weight', 'gold_cost', 'craftsmanship_cost', 'polishing', 'gold_color_id', 'size', 'gold_cost', 'is_sample_provided', 'sample_description', 'setting_cost', 'backing_cost', 'backing_type', 'backing_size', 'backing_quantity', 'claw' ];

        if(JobType::BESPOKE == JobType::typeById($this->type_id)){
            $newRequestData =  $this->_unsetMultipleItems($this->all(), $notInBespokeArr);
        }else{
            $newRequestData =  $this->_unsetMultipleItems($this->all(), $notInRepairArr);
        }
        $this->replace($newRequestData);
    }

    public function _unsetMultipleItems($requestData, $notInArrayData)
    {
        foreach ($requestData as $key => $value) {
            if(in_array($key, $notInArrayData)){
                unset($requestData[$key]);
            }
        }
        return $requestData;
    }

}

