<?php

namespace App\Http\Requests\Admin\Jewelleries;

use App\Models\JobType;
use Illuminate\Foundation\Http\FormRequest;

class JewelleryReviewCostsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'jewellery_id'        => "required|integer|not_in:0",
            'item_code'           => "required|unique:jewelleries,item_code,".$this->jewellery_id,
            'date'                => "required|date",
            'type_id'             => "required|integer|not_in:0",
            'cost_price'          => "required|numeric|between:0.01,9999999999.99",
            'gst_percent'         => "nullable|numeric",
            'gst_amount'          => "nullable|numeric",
            'mark_up'             => "required|numeric|between:0.01,9999999999.99",
            'mark_up_usd'         => "required|numeric|between:0.01,9999999999.99",
            'mark_up_hkd'         => "required|numeric|between:0.01,9999999999.99",
            'usd_exchange_rate'   => "required|numeric|between:0.01,999.99",
            'hkd_exchange_rate'   => "required|numeric|between:0.01,999.99",
            'sub_total'           => "nullable|numeric",
            'total'               => "nullable|numeric",
        ];
    }

    public function messages()
    {
        return [

        ];
    }
}

