<?php

namespace App\Http\Requests\Admin\Jewelleries;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Jewellery;
use App\Models\Type;

class JewelleriesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $typeId = 0;

        if(Type::BESPOKE == Type::typeById($this->type_id)){
            $typeId = Type::getTypeIdByName(Type::BESPOKE);
        }
       
        if ($this->id) {
          
            $jewellery = [
                'jewellery_id'             => "nullable|integer|not_in:0",
                'date'                     => "required|date",
                'estimate_completion'      => "nullable|required_if:type_id,==,$typeId",
                'type_id'                  => "required|integer|not_in:0",
                'description'              => "nullable|string",
                'category_id'              => "required|integer|not_in:0",
                'gold_color_id'            => "required|integer|not_in:0",
                'size'                     => "nullable|numeric|between:0.01,99999.99",
                'is_sample_provided'       => "nullable|in:".Jewellery::ZERO.",".Jewellery::ONE,
                'sample_description'       => "nullable",//"required_if:is_sample_provided,".Jewellery::ONE, 
                'gold_cost'                => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
                'gold_weight'              =>"nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
                'workmanship_cost'         => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
                'pollising_cost'           => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
                'setting_cost'             => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
                'earing_pin'               => "nullable|numeric|between:0.01,9999999999.99",
                'backing_cost'             => "nullable|numeric|between:0.01,9999999999.99",
                'backing_type'             => "nullable",
                'backing_size'             => "nullable|numeric|between:0.01,9999999999.99",
                'backing_quantity'         => "nullable|integer|between:0.01,9999999999.99",
                'claw'                     => "nullable|required_if:type_id,==,$typeId",
                'jewelleries.*.stock_no'   => "nullable|string|max:6",
                'jewelleries.*.weight'     => "nullable|numeric|between:0.01,9999999999.99|required_with:jewelleries.*.stock_no",
                'jewelleries.*.unit_price' => "nullable|numeric|between:0.01,9999999999.99|required_with:jewelleries.*.stock_no",
                'jewelleries.*.price'      => "nullable|numeric|between:0.01,9999999999.99|required_with:jewelleries.*.stock_no",
                'staff_id'                 => "nullable|integer|not_in:0|required_if:type_id,==,$typeId",
                'customer_phone'           => "nullable|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15|required_if:type_id,==,$typeId",
                'customer_name'            =>  "nullable|string|max:30|regex:/^[a-zA-Z ]+$/|required_if:type_id,==,$typeId",
                'customer_email'           => "nullable|email:rfc,dns,filter|required_if:type_id,==,$typeId",
                'drawing_textarea_base64'  => "nullable",
                'awb_no'                   => "nullable|string|max:50|min:3",
                'worksmith_id'             => "nullable|integer|not_in:0",
                'jewellery_id'             => "nullable|integer|not_in:0",
                'images'                   => "nullable",
            ];
        } else {
            // dd($this);
            $jewellery = [
                'date'                     => "required|date",
                'estimate_completion'      => "nullable|required_if:type_id,==,$typeId",
                'type_id'                  => "required|integer|not_in:0",
                'description'              => "nullable|string",
                'category_id'              => "required|integer|not_in:0",
                'gold_color_id'            => "required|integer|not_in:0",
                'size'                     => "nullable|numeric|between:0.01,99999.99",
                'is_sample_provided'       => "nullable|in:".Jewellery::ZERO.",".Jewellery::ONE,
                'sample_description'       => "nullable", //"required_if:is_sample_provided,".Jewellery::ONE, 
                'gold_cost'                => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
                'gold_weight'              =>"nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
                'workmanship_cost'         => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
                'pollising_cost'           => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
                'setting_cost'             => "nullable|required_if:type_id,==,$typeId|numeric|between:0.01,9999999999.99",
                'earing_pin'               => "nullable|numeric|between:0.01,9999999999.99",
                'backing_cost'             => "nullable|numeric|between:0.01,9999999999.99",
                'backing_type'             => "nullable",
                'backing_size'             => "nullable|numeric|between:0.01,9999999999.99",
                'backing_quantity'         => "nullable|integer|between:0.01,9999999999.99",
                'claw'                     => "nullable|required_if:type_id,==,$typeId",
                'jewelleries.*.stock_no'   => "nullable|string|max:6",
                'jewelleries.*.weight'     => "nullable|numeric|between:0.01,9999999999.99|required_with:jewelleries.*.stock_no",
                'jewelleries.*.unit_price' => "nullable|numeric|between:0.01,9999999999.99|required_with:jewelleries.*.stock_no",
                'jewelleries.*.price'      => "nullable|numeric|between:0.01,9999999999.99|required_with:jewelleries.*.stock_no",
                'staff_id'                 => "nullable|integer|not_in:0|required_if:type_id,==,$typeId",
                'customer_phone'           => "nullable|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15|required_if:type_id,==,$typeId",
                'customer_name'            => "nullable|string|max:30|regex:/^[a-zA-Z ]+$/|required_if:type_id,==,$typeId",
                'customer_email'           => "nullable|email:rfc,dns,filter|required_if:type_id,==,$typeId",
                'drawing_textarea_base64'  => "nullable",
                'awb_no'                   => "nullable|string|max:50|min:3",
                'worksmith_id'             => "nullable|integer|not_in:0",
                'jewellery_id'             => "nullable|integer|not_in:0",
                'images'                   => "nullable",
            ];
        }

        return $jewellery;
    }

    public function messages()
    {
        return [
            'category_id.required'                   => 'The Category field is required.',
            'type_id.required'                       => 'The Type field is required.',
            'gold_color_id.required'                 => 'Gold color field is required. ',
            'gold_cost.required_if'                  => 'Gold cost field is required. ',
            'gold_weight.required_if'                => 'Gold weight field is required.',
            'workmanship_cost.required_if'           => 'Workmanship field is required.',
            'pollising_cost.required_if'             => 'Pollising cost field is required.',
            'setting_cost.required_if'               => 'Setting cost field is required.',
            'sample_description.required_if'         => ' Sample Description field is required.',
            'estimate_completion.required_if'        => ' Estimate Completion field is required.',
            'claw.required_if'                       => 'Claw field is required.',
            'staff_id.required'                      => 'Staff field is required.',
            'staff_id.required_if'                   => 'Handled By field is required.',
            'customer_phone.required_if'             => 'Customer phone field is required.',
            'customer_name.required_if'              => 'Customer name field is required.',
            'customer_email.required_if'             => 'Customer email field is required.',
            'worksmith_id.required_if'               => 'Worksmith field is required.',
            'sample_description.required_if'         => 'The sample description field is required when is sample provided is Yes.',
            'jewelleries.*.stock_no.max'             => 'The stock no. must not be greater than 6 characters.',
            'jewelleries.*.weight.numeric'           => 'The weight must be a number.',
            'jewelleries.*.unit_price.numeric'       => 'The unit price must be a number.',
            'jewelleries.*.price.numeric'            => 'The price must be a number.',
            'jewelleries.*.weight.between'           => 'The weight must be between 0.01 and 9999999999.99.',
            'jewelleries.*.unit_price.between'       => 'The unit price must be between 0.01 and 9999999999.99.',
            'jewelleries.*.price.between'            => 'The price must be between 0.01 and 9999999999.99.',
            'jewelleries.*.price.required_with'      => 'The price field is required.',
            'jewelleries.*.weight.required_with'     => 'The weight field is required.',
            'jewelleries.*.unit_price.required_with' => 'The unit price field is required.',
        ];
    }
}

