<?php

namespace App\Http\Requests\Admin\Jewelleries;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Jewellery;
use App\Models\Type;

class JewelleriesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $typeId = 0;

        if(Type::PURCHASED == Type::typeById($this->type_id)){

            if ($this->id) {

                $jewellery = [
                    'jewellery_id'             => "nullable|integer|not_in:0",
                    'item_code'                => "required|unique:jewelleries,item_code,".$this->id,
                    'date'                     => "required|date",
                    'type_id'                  => "required|integer|not_in:0",
                    'category_id'              => "required|integer|not_in:0",
                    'gold_color_id'            => "required|integer|not_in:0",
                    'description'              => "nullable|string",
                    'size'                     => "nullable|numeric|between:0.01,99999.99",
                    'drawing_textarea_base64'  => "nullable",
                    'awb_no'                   => "nullable|string|max:50|min:3",
                    'images'                   => "nullable",
                ];
            } else {
                $jewellery = [
                    'date'                     => "required|date",
                    'type_id'                  => "required|integer|not_in:0",
                    'category_id'              => "required|integer|not_in:0",
                    'gold_color_id'            => "required|integer|not_in:0",
                    'description'              => "nullable|string",
                    'size'                     => "nullable|numeric|between:0.01,99999.99",
                    'drawing_textarea_base64'  => "nullable",
                    'awb_no'                   => "nullable|string|max:50|min:3",
                    'jewellery_id'             => "nullable|integer|not_in:0",
                    'images'                   => "nullable",
                ];
            }
        } else{
            if ($this->id) {
                $jewellery = [
                    'job_id'                   => "nullable|integer|not_in:0",
                    'date'                     => "required|date",
                    'estimate_completion'      => "required|date",
                    'type_id'                  => "required|integer|not_in:0",
                    'description'              => "nullable|string",
                    'category_id'              => "required|integer|not_in:0",
                    'gold_color_id'            => "required|integer|not_in:0",
                    'size'                     => "nullable|numeric|between:0.01,99999.99",
                    'is_sample_provided'       => "nullable|in:".Jewellery::ZERO.",".Jewellery::ONE,
                    'sample_description'       => "required_if:is_sample_provided,".Jewellery::ONE,
                    'gold_cost'                => "required|numeric",
                    'gold_weight'              => "required|numeric|between:0.01,9999999999.99",
                    'workmanship_cost'         => "required|numeric",
                    'pollising_cost'           => "required|numeric",
                    'setting_cost'             => "required|numeric",
                    'earing_pin'               => "nullable|numeric|between:0.01,9999999999.99",
                    'backing_cost'             => "nullable|numeric",
                    'backing_type'             => "nullable",
                    'backing_size'             => "nullable|numeric|between:0.01,9999999999.99",
                    'backing_quantity'         => "nullable|integer|between:0.01,9999999999.99",
                    'claw'                     => "required|string|in:".Jewellery::EAGLE.",".Jewellery::ROUND.",".Jewellery::SQUARE.",".Jewellery::NO_CLAW,
                    'jewelleries.*.stock_no'   => "nullable|string",
                    'jewelleries.*.weight'     => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'jewelleries.*.unit_price' => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'jewelleries.*.price'      => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'staff_id'                 => "nullable|integer|not_in:0",
                    'customer_phone'           => "nullable|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15",
                    'customer_name'            =>  "nullable|string|max:50|regex:/^[a-zA-Z ]+$/",
                    'customer_email'           => "nullable|email|max:190",
                    'drawing_textarea_base64'  => "nullable",
                    'images'                   => "nullable",
                    'worksmith_id'             => "nullable|integer|not_in:0",
                ];
            } else {
                $jewellery = [
                    'job_id'                   => "nullable|integer|not_in:0",
                    'date'                     => "required|date",
                    'estimate_completion'      => "required|date",
                    'type_id'                  => "required|integer|not_in:0",
                    'description'              => "nullable|string",
                    'category_id'              => "required|integer|not_in:0",
                    'gold_color_id'            => "required|integer|not_in:0",
                    'size'                     => "nullable|numeric|between:0.01,99999.99",
                    'is_sample_provided'       => "nullable|in:".Jewellery::ZERO.",".Jewellery::ONE,
                    'sample_description'       => "required_if:is_sample_provided,".Jewellery::ONE,
                    'gold_cost'                => "required|numeric",
                    'gold_weight'              => "required|numeric|between:0.01,9999999999.99",
                    'workmanship_cost'         => "required|numeric",
                    'pollising_cost'           => "required|numeric",
                    'setting_cost'             => "required|numeric",
                    'earing_pin'               => "nullable|numeric|between:0.01,9999999999.99",
                    'backing_cost'             => "nullable|numeric",
                    'backing_type'             => "nullable",
                    'backing_size'             => "nullable|numeric|between:0.01,9999999999.99",
                    'backing_quantity'         => "nullable|integer|between:0.01,9999999999.99",
                    'claw'                     => "required|string|in:".Jewellery::EAGLE.",".Jewellery::ROUND.",".Jewellery::SQUARE.",".Jewellery::NO_CLAW,
                    'jewelleries.*.stock_no'   => "nullable|string",
                    'jewelleries.*.weight'     => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'jewelleries.*.unit_price' => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'jewelleries.*.price'      => "nullable|numeric|required_with:jewelleries.*.stock_no",
                    'staff_id'                 => "nullable|integer|not_in:0",
                    'customer_phone'           => "nullable|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15",
                    'customer_name'            => "nullable|string|max:50|regex:/^[a-zA-Z ]+$/",
                    'customer_email'           => "nullable|email|max:190",
                    'drawing_textarea_base64'  => "nullable",
                    'images'                   => "nullable",
                    'worksmith_id'             => "nullable|integer|not_in:0",
                ];
            }
        }

        return $jewellery;
    }

    public function messages()
    {
        return [
            'category_id.required'                   => 'The Category field is required.',
            'type_id.required'                       => 'The Type field is required.',
            'gold_color_id.required'                 => 'Gold color field is required. ',
            'staff_id.required'                      => 'Staff field is required.',
            'sample_description.required_if'         => 'The sample description field is required when is sample provided is Yes.',
            // 'jewelleries.*.stock_no.max'             => 'The stock no. must not be greater than 6 characters.',
            'jewelleries.*.weight.numeric'           => 'The weight must be a number.',
            'jewelleries.*.unit_price.numeric'       => 'The unit price must be a number.',
            'jewelleries.*.price.numeric'            => 'The price must be a number.',
            // 'jewelleries.*.weight.between'           => 'The weight must be between 0.01 and 9999999999.99.',
            // 'jewelleries.*.unit_price.between'       => 'The unit price must be between 0.01 and 9999999999.99.',
            // 'jewelleries.*.price.between'            => 'The price must be between 0.01 and 9999999999.99.',
            'jewelleries.*.price.required_with'      => 'The price field is required.',
            'jewelleries.*.weight.required_with'     => 'The weight field is required.',
            'jewelleries.*.unit_price.required_with' => 'The unit price field is required.',
        ];
    }

    protected function prepareForValidation()
    {
        $newRequestData = [];
        $notInBespokeArr = [ 'awb_no'];

        $notInPurchasedArr = [ 'estimate_completion','earing_pin', 'gold_weight', 'gold_cost', 'workmanship_cost', 'pollising_cost', 'gold_cost', 'is_sample_provided', 'sample_description', 'setting_cost', 'backing_cost', 'backing_type', 'backing_size', 'backing_quantity', 'claw','worksmith_id','jewelleries','staff_id','customer_phone','customer_name','customer_email' ];

        if(Type::PURCHASED == Type::typeById($this->type_id)){
            $newRequestData =  $this->_unsetMultipleItems($this->all(), $notInPurchasedArr);
        }else{
            $newRequestData =  $this->_unsetMultipleItems($this->all(), $notInBespokeArr);
        }
        $this->replace($newRequestData);
    }

    public function _unsetMultipleItems($requestData, $notInArrayData)
    {
        foreach ($requestData as $key => $value) {
            if(in_array($key, $notInArrayData)){
                unset($requestData[$key]);
            }
        }
        return $requestData;
    }
}

