<?php

namespace App\Http\Requests\Admin\Customers;

use Illuminate\Foundation\Http\FormRequest;

class CustomersRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */

    public function rules()
    {
        if ($this->id) {
           
            $customers = [
                'fullname'     => 'required|min:3|max:50|regex:/^[a-zA-Z ]+$/',
                'email'        => 'required|email:rfc,dns,filter|unique:users,email,' . $this->id,
                'phone'        => "required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15|unique:users,phone,".$this->id,
                'image'        => 'nullable',
                'country_code' => 'nullable',
                'dob'          => 'nullable|date|before:5 years ago',
                'gender'       => 'required|in:0,1',
                'address'      => 'nullable|max:255',
                'remarks'      => 'nullable|max:255',
            ];
        } else {
            $customers = [
                'fullname'     => 'required|min:3|max:50|regex:/^[a-zA-Z ]+$/',
                'email'        => 'required|email:rfc,dns,filter|unique:users,email,' . $this->id,
                'image'        => 'nullable',
                'phone'        => "required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15|unique:admins,phone,".$this->id,
                'country_code' => 'nullable',
                'dob'          => 'nullable|date|before:5 years ago',
                'gender'       => 'required|in:0,1',
                'address'      => 'nullable|max:255',
                'remarks'      => 'nullable|max:255',
            ];
        }
        return $customers;
    }
}
