<?php

namespace App\Http\Requests\Admin\Consignments;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Type;

class ConsignmentsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $typeId = 0;

        if(Type::BESPOKE == Type::typeById($this->type_id)){
            $typeId = Type::getTypeIdByName(Type::BESPOKE);
        }

        if ($this->id) {
            $consignments = [
                // 'consignment_no'   => "nullable",
                'reference_date'   => "required|date",
                'category_id'      => "required|integer|not_in:0",
                'description'      => "nullable|string",
                'weight'           => "required|numeric|between:0.01,9999999999.99",
                'unit_price'       => "required|numeric|between:0.01,9999999999.99",
                'unit'             => "required",
                'customer_phone'   => "required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15",
                'customer_name'    => "required|max:30|regex:/^[a-zA-Z ]+$/",
                'customer_email'   => "required|email|max:255",
                'staff_id'         => "required|integer|not_in:0",
            ];

        } else {
            $consignments = [
                // 'consignment_no' => "nullable",
                'reference_date' => "required|date",
                'category_id'    => "required|integer|not_in:0",
                'description'    => "nullable|string",
                'weight'         => "required|numeric|between:0.01,9999999999.99",
                'unit_price'     => "required|numeric|between:0.01,9999999999.99",
                'unit'           => "required",
                'customer_phone' => "required|regex:/^(\+[1-9]{1,3}[- ])?[6-9][0-9]\d{4,14}$/|max:15",
                'customer_name'  => "required|max:30|regex:/^[a-zA-Z ]+$/",
                'customer_email' => "required|email|max:255",
                'staff_id'       => "required|integer|not_in:0",
            ];
        }
        return $consignments;
    }

    public function messages()
    {
        return [
           'category_id.required' => 'The category field is required.',
           'staff_id.required'    => 'The staff field is required.',
        ];
    }
}
