<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class CategoriesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if($this->id){
            $categories = [
                'name'   => 'required|string|unique:categories,name,'.$this->id.',id',
                'status' => 'nullable|string',
                'image'  => 'nullable|image|mimes:svg',
                'icon_image'  => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            ];
        } else {
            $categories = [
                'name'   => 'required|string|unique:categories,name,'.$this->id.',id',
                'status' => 'nullable|string',
                'image'  => 'required|image|mimes:svg',
                'icon_image'  => 'required|image|mimes:jpeg,png,jpg,gif,svg',
            ];
        }
        return $categories;
    }

    public function messages()
    {
        return [
            'name.required' => 'The category field is required',
        ];
    }
}
