<?php

namespace App\Http\Middleware;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Exceptions\UnauthorizedException;
use App\Models\Permission;
use Closure;
use Route;


class PermissionMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle($request, Closure $next, $roleOrPermission, $guard = null)
    {
        $permission_list = Permission::getPermissionListWithRouteName();
        
        $current_route_name = Route::currentRouteName();  
        $roleOrPermission = @$permission_list[$current_route_name];
        
        $roleOrPermission = ($roleOrPermission) ? implode('|',$roleOrPermission) : null; // $roleOrPermission ; 
      
        $authGuard = Auth::guard($guard);

        if ($authGuard->guest()) {
            throw UnauthorizedException::notLoggedIn();
        }

        $rolesOrPermissions = is_array($roleOrPermission)  ? $roleOrPermission: explode('|', $roleOrPermission);
        if (! $authGuard->user()->hasAnyRole($rolesOrPermissions) && ! $authGuard->user()->hasAnyPermission($rolesOrPermissions)) {
            throw UnauthorizedException::forRolesOrPermissions($rolesOrPermissions);
        }
    
        return $next($request);
    }
}
