<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\models\Admin;
use Auth;
use Log;

class SwitchDashboardsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
       // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function switchDashboard($requestFor)
    {
        $res = [];
        try{
            $currentGuard = '';
            $currentUser = '';
            if(Auth::guard('web')->check()){
                $currentGuard = 'web';
                $currentUser = Auth::guard('web')->user();
            }else if(Auth::guard('admin')->check()){
                $currentGuard = 'admin';
                $currentUser = Auth::guard('admin')->user();
            }

            $requestedGuard = $requestFor;

            $routeToBeRedirect = ($requestedGuard == 'admin') ? route('admin.dashboard.index') : route('dashboard');

            $loginUser = $this->findOrUpdateUser($currentUser,$requestedGuard);

            if ($loginUser) {
                $res['status'] = 1;
                $res['message'] = ucfirst($requestFor).' Dashboard for you!!';
                $res['data'] = $routeToBeRedirect;
            }else{
                $res['status'] = 0;
                $res['message'] = 'Something went wrong!';
            } 
        } catch (\Exception $err) {
            Log::error('Error in switchDashboard on Front\SwitchDashboardsController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return response()->json($res);
    }

    protected function findOrUpdateUser($userToBeLogin, $requestedGuard)
    {
        $user = Admin::whereEmail($userToBeLogin->email)->first(); 
        if ($user) {
            if (Auth::guard($requestedGuard)->login($user)) {
                return $user;
            }
        }
        return $user;
    }

    
     
}
