<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Components\CustomerComponent;
use App\Http\Controllers\Components\MultipleDropzoneComponent;
use Illuminate\Http\Request;
use App\Http\Requests\jobs\JobItemsRequest;
use App\Http\Requests\jobs\JobsRequest;
use App\Helpers\CommonHelper;
use App\Models\ReviewCost;
use App\Models\GoldColor;
use App\Models\Category;
use App\Models\JobType;
use App\Models\Setting;
use App\Models\User;
use App\Models\Job;
use File;
use Auth;
use Log;
use DB;


class JobsController extends Controller
{
    // const ZEROES = 5;
    // const Job = 'Quotation';
    const JOB = 'Job';
    const ZEROES = 5;

    function __construct(MultipleDropzoneComponent $multipleDropzone)
    {
        $this->MultipleDropzoneComponent = $multipleDropzone;
        $this->CustomerComponent = new CustomerComponent();
    }

    public function repairCreate()
    {
        try {
            return view('frontend.jobs.create');
        } catch (\Exception $err) {
            Log::error('Error in repairCreate on Front\JobsController :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function bespokecreate()
    {
        try {
            return view('frontend.jobs.create');
        } catch (\Exception $err) {
            Log::error('Error in bespokecreate on Front\JobsController :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function bespokeReairData(JobItemsRequest $request)
    {
    try {
        // dd($request['job']);
        $buttonIndex = $request->button_index;


        foreach($request['job'] as $key=>$value){
            foreach($value as $val_1){
                    $stockJewelley =   collect($val_1['jewelleries']);
                    $priceArr = $stockJewelley->map(function ($price){
                        return  $price['price'];
                    });
                    $priceArr  =  $priceArr->toArray();
                    $calPrice = array_sum($priceArr);

            }
        }

        if ($buttonIndex || $buttonIndex== 0) {
            $render_Button = view("frontend.jobs.button_render")->render();
            $renderShowItem = view("frontend.jobs.show_bes_rep_render",compact('calPrice'))->render();
            $res['status'] = 1;
            $res['message'] = 'Item Added successfully!';
            $res['render_button'] = $render_Button;
            $res['show_item'] = $renderShowItem;
        } else {
            $res['status'] = 0;
            $res['message'] = 'Item not found!';
        }
        } catch (\Exception $err) {
            Log::error('Error in bespokeReairData on Frontend/JobsController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
     }
        return response()->json($res);
    }

    public function store(JobsRequest $request)
    {
        DB::beginTransaction();
        try {
            $res = [];
            $customerData = $request->only(['customer_name', 'customer_email', 'customer_phone']);
            $customerRes = $this->CustomerComponent->addOrupdateCustomer($customerData, self::JOB);

            if($request->subtotal != 0){

                if ($customerRes['status'] == 1) {
                    $jobids = [];

                    foreach ($request->job as $key => $data) {
                        foreach($data as $value) {
                            if (!empty($value['checked'])) {
                                $inputData = $value;
                                unset($inputData['checked'],$inputData['illustration'] , $inputData['price'], $inputData['images']  );
                                $inputData['staff_id'] = Auth::guard('web')->user()->id;
                                $inputData['job_type_id'] = JobType::getTypeIdByName($request->job_type);
                                $inputData['job_status'] =  Job::NOT_ASSIGNED;
                                $inputData['customer_id'] = $customerRes['data'];
                                $inputData['is_jewellery_received'] = $inputData['customer_recieved'] ?? 0;
                                $inputData['additional_material']  = $inputData['material'];
                                $inputData['material_quantity']  = $inputData['quantity'];
                                $inputData['additional_information']  = $inputData['additional_information'];
                                $inputData['date'] = date('Y-m-d');

                                if(!empty($value['illustration'])){
                                    if (!empty($inputData['drawing_textarea_base64'])) {
                                        $drawingImageName = CommonHelper::uploadBase64Image($inputData['drawing_textarea_base64'], Job::DRAWING_PATH);
                                        $inputData['drawing_image'] = $drawingImageName;
                                    }
                                }

                            $job = Job::create($inputData);
                            if ($job->exists()) {

                                $updateItemCodeRes = $this->_updateItemCode(self::JOB, $job->id);
                                if ($updateItemCodeRes['status'] == 1) {
                                     $this->_addReviewCost($value, $job);
                                    if(!empty($value['illustration'])){
                                        if (!empty($value['images'])) {
                                            $this->addJobImages($job, $value['images']);
                                        }
                                    }
                                    if (!empty($value['jewelleries'])) {
                                        $this->addJobLoosePieces($job, $value['jewelleries']);
                                    }
                                    array_push($jobids,$job->id);
                                } else {
                                    $res['status'] = 0;
                                    $res['message'] =  $updateItemCodeRes['message'];
                                }
                            } else{
                                $res['status'] = 0;
                                $res['message'] = "Job not added!";
                            }
                           }
                        }
                    }

                    DB::commit();
                    $res['status'] = 1;
                    $res['job_ids'] = $jobids;
                    $res['message'] =  "Job Added Successfully!";
                } else {
                    $res['status'] = 0;
                    $res['message'] = $customerRes['message'];
                }
            } else {
                $res['status'] = 0;
                $res['message'] = "Please select price!";
            }
        } catch (\Exception $err) {
            DB::rollback();
            Log::error('Error in store on Frontend/JobsController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return response()->json($res);
    }

    public function addJobLoosePieces($job, $jobLoosePieces)
    {
        try {
            foreach ($jobLoosePieces as $value) {
                if (!empty($value['stock_no']) && !empty($value['weight']) && !empty($value['unit_price']) && !empty($value['price'])) {
                    $value['job_id'] = $job->id;
                    $job->loose_pieces()->create($value);
                }
            }
          return true;
        } catch (\Exception $err) {
            Log::error('Error in addJobLoosePieces on Frontend/JobsController :' . $err->getMessage());
            return false;
        }
    }

    public function _updateItemCode($string, $job_id)
    {
        $res = [];
        try {
            if ($string == self::JOB) {
                $record = Job::findOrFail($job_id);
            } else {
                $record = Jewellery::findOrFail($job_id);
            }

            $record->item_code = getItemCode(self::ZEROES, $job_id, $string);
            $record->save();
            if ($record->wasChanged()) {
                $res['status'] = 1;
                $res['message'] = "Item Code updated successfully.";
                $res['data'] = $record->item_code;
            } else {
                $res['status'] = 0;
                $res['message'] = "Item Code not updated!";
            }
        } catch (\Exception $err) {
            Log::error('Error in _updateItemCode on Frontend/JobsController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return $res;
    }

    // Automatically insert review cost when creating a new job
    public function _addReviewCost($inputData, $job)
    {
        try{
            $setting =  Setting::price_settings();
            $review_cost_data = [];
            $cost_price = $inputData['price'];
            $sub_total = $cost_price;
            $gst_percent  =  $setting['gst_percent'];
            $gst_amount = ($sub_total * $gst_percent) /100;
            $total = $sub_total + $gst_amount;
            $review_cost_data['job_id'] = $job->id;
            $review_cost_data['cost_price'] = $cost_price;
            $review_cost_data['sub_total'] = $sub_total;
            $review_cost_data['gst_percent'] = $gst_percent;
            $review_cost_data['gst_amount'] = $gst_amount;
            $review_cost_data['total'] = $total;
            $review_cost = ReviewCost::firstOrNew(['job_id'=>$job->id]);
            $review_cost->fill($review_cost_data);
            if($review_cost->save()){
                return true;
            }else{
                return false;
            }
        } catch (\Exception $err) {
            Log::error('Error in _addReviewCost on Frontend/JobsController :' . $err->getMessage());
            return false;
        }
    }

    public function addJobImages($job,$job_images)
    {
        try {
            $res = [];

            foreach ($job_images as $val_img){
                $this->MultipleDropzoneComponent->storeImage($val_img, Job::IMAGE_PATH, Job::TEMP_PATH, Job::TABLENAME);
                $store_images= $job->images()->create([
                    'job_id' => $job->id,
                    'image' => $val_img,
                ]);
            }
            $res['status'] = 1;
            $res['message'] = "Job images added successfully!";
        } catch (\Exception $err) {
            Log::error('Error in addJobImages on Frontend/JobsController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return $res;
    }

    public function printJob($job_id)
    {
        try {
            $job_id = explode(',', $job_id);
            $job = Job::whereIn('id',$job_id)->with(['staff', 'customer', 'review_cost','images'=>function($q) {
                $q->first();
            }, 'gold_color','category','loose_pieces'])->get();

         return view('frontend.jobs.print.print_job', compact('job'));
        } catch (\Exception $err) {
            Log::error('Error in printQuotation on Front\QuotationsController :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

}

