<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use Log;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
       // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        try{
            if(Auth::guard('web')->check()){
                return redirect()->route('dashboard');
            }
            return view('home.index');
        } catch (\Exception $err) {
            Log::error('Error in index on Front\HomeController :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function dashboard()
    {
        try{
            return view('home.dashboard');
        } catch (\Exception $err) {
            Log::error('Error in dashboard on Front\HomeController :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }
     
}
