<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Log;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    const TOAST_SUCCESS = 'Success';
	const TOAST_ERROR = 'Error';
	const TOAST_ACTION_FAILED = 'Action Failed!';

    protected function separateDetailsFromPhoneInput($phoneInput)
    {
        try{
            $res = [];
            if(strpos($phoneInput, ' ') !== false){
                $phoneNo_with_code = explode(' ', $phoneInput);
                $res['country_code'] = (count($phoneNo_with_code) > 1) ? $phoneNo_with_code[0] : null;
                $res['phone'] = (count($phoneNo_with_code) > 1) ? $phoneNo_with_code[1] : $phoneNo_with_code[0];
            }elseif(strpos($phoneInput, '-') !== false){
                $phoneNo_with_code = explode('-', $phoneInput);
                $res['country_code'] = (count($phoneNo_with_code) > 1) ? $phoneNo_with_code[0] : null;
                $res['phone'] = (count($phoneNo_with_code) > 1) ? $phoneNo_with_code[1] : $phoneNo_with_code[0];
            }else{
                $res['country_code'] = null;
                $res['phone'] = $phoneInput;
            }
            return $res;
        } catch (\Exception $err) {
            Log::error('Error in separateDetailsFromPhoneInput on Controller :' . $err->getMessage());
        }
    }

	/**
     *
     * @var unknown
     */
    protected $data;
    /**
     */
    protected function sendResponse($isSuccess = 1, $message = "", $data=array())
    {
        
        $return=$data;
        if($this->data){
            $return['data'] = $this->data ?? null;
        }

        // if($this->data){
        //     if(!is_array($this->data) && !is_string($this->data)){
        //         $this->data = $this->data->toArray();
        //     }
        // }
        
        $return['status'] = $isSuccess ?? 0;
        $return['message'] = $message ?? null;
        // $return['count'] = is_array($this->data) ? count($this->data) : 0;
       
        // $return['first_error'] = $this->first_error ?? null; 
        // $return['all_errors'] = $this->all_errors ?? array(); 
        return $return;
        // return response()->json($return);
    }

}
