<?php
namespace App\Http\Controllers\Components;
use App\Models\Worksmith;
use App\Models\Admin;
use App\Models\User;
use Image;
use File;
use Log;

Class SingleDropzoneComponent
{

    function ajaxStoreTmpImage($request)
    {
        try {
            $image = $request->file('file');
            $tableName = $request->table;
            $originalName = $image->getClientOriginalName();
            $imageName = $tableName . time() . rand(0, 9999) . $originalName;
            if(!empty($tableName) && $tableName== Admin::TABLENAME ){
                $temPathDir = Admin::TEMP_PATH;
            }

            if(!empty($tableName) && $tableName== User::TABLENAME ){
                $temPathDir = User::TEMP_PATH;
            }

            if(!empty($tableName) && $tableName== Worksmith::TABLENAME ){
                $temPathDir = Worksmith::TEMP_PATH;
            }

            if (!File::exists(public_path($temPathDir))) {
                File::makeDirectory(public_path($temPathDir. auth()->user()->id . '/'.$tableName), 0755, true, true);
            }

            $image = $image->move(public_path($temPathDir . auth()->user()->id . '/'.$tableName), $imageName);
            return $imageName;
        } catch (\Exception $err) {
            Log::error('Error in ajaxStoreImage on SingleDropzoneComponent :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    function storeImage($validated, $imagePath, $tmpDirPath, $tableName, $thumbImagePath, $thumbSize)
    {
        try {
            if (!empty($validated['image'])) {
                if (!File::exists(public_path($imagePath))) {
                    File::makeDirectory(public_path($imagePath), 0755, true, true);
                }

                if (!File::exists(public_path($thumbImagePath))) {
                    File::makeDirectory(public_path($thumbImagePath), 0755, true, true);
                }

                if (File::exists(public_path($tmpDirPath.auth()->user()->id.'/'.$tableName.'/'.$validated['image']))) {
                    File::copy(public_path($tmpDirPath.auth()->user()->id.'/'.$tableName).'/'.$validated['image'], public_path($imagePath.'/'.$validated['image']));

                    $image = Image::make(public_path($imagePath.'/'.$validated['image']));
                    $image->resize($thumbSize, null, function ($constraint) {
                        $constraint->aspectRatio();
                    });
                    $image->save(public_path($thumbImagePath.'/'.$validated['image'])); 

                    $temp_path = public_path($tmpDirPath.auth()->user()->id.'/'.$tableName).'/'.$validated['image'];
                    File::delete($temp_path);
                }
            }
        } catch (\Exception $err) {
            Log::error('Error in storeImage on SingleDropzoneComponent :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    function updateImage($validated, $record, $imagePath, $tmpDirPath, $tableName, $thumbImagePath, $thumbSize)
    {
        try {
            $exist_image = $record->image;

            if (!File::exists(public_path($imagePath))) {
                File::makeDirectory(public_path($imagePath), 0755, true, true);
            }
            if (!File::exists(public_path($thumbImagePath))) {
                File::makeDirectory(public_path($thumbImagePath), 0755, true, true);
            }

            if (!empty($validated['image'])) { 
                if (File::exists(public_path($tmpDirPath . auth()->user()->id . '/'.$tableName . '/' . $validated['image']))) {
                    File::copy(public_path($tmpDirPath. auth()->user()->id . '/'.$tableName) . '/' . $validated['image'], public_path($imagePath. '/' . $validated['image']));

                    $image = Image::make(public_path($imagePath. '/' . $validated['image']));
                    $image->resize($thumbSize, null, function ($constraint) {
                        $constraint->aspectRatio();
                    });
                    $image->save(public_path($imagePath. '/thumb/' . $validated['image'])); 

                    $temp_path = public_path($tmpDirPath . auth()->user()->id . '/'.$tableName) . '/' . $validated['image'];
                    File::delete($temp_path);

                    $old_image_path = public_path($imagePath) . '/' . $record->image;
                    if (File::exists($old_image_path)) {
                        File::delete($old_image_path);
                    }

                    $old_thumb_image_path = public_path($thumbImagePath) . '/' . $record->image;
                    if (File::exists($old_thumb_image_path)) {
                        File::delete($old_thumb_image_path);
                    }
                }
            } else { 
                $old_image_path = public_path($imagePath) . '/' . $exist_image;
                if (File::exists($old_image_path)) {
                    File::delete($old_image_path);
                }

                $old_thumb_image_path = public_path($thumbImagePath) . '/' . $exist_image;
                if (File::exists($old_thumb_image_path)) {
                    File::delete($old_thumb_image_path);
                }

                $validated['image'] = null;
            }
            return $validated['image'];
        } catch (\Exception $err) {
            Log::error('Error in updateImage on SingleDropzoneComponent :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    function deleteImage($record,$imagePath, $thumbImagePath)
    {
        try {
            $oldImage = $record->image;
            $oldImageArray = explode('/', $oldImage);
            $oldImageName = end($oldImageArray);
            $old_image_path = public_path($imagePath) . '/' . $oldImageName;
            if (File::exists($old_image_path)) {
                File::delete($old_image_path);
            }
            $old_thumb_image_path = public_path($thumbImagePath) . '/' . $oldImageName;
            if (File::exists($old_thumb_image_path)) {
                File::delete($old_thumb_image_path);
            }
        } catch (\Exception $err) {
            Log::error('Error in deleteImage on SingleDropzoneComponent :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

}