<?php

namespace App\Http\Controllers\Components;

use App\Models\Quotation;
use Log;
use DB;

Class QuotationComponent
{
    public function getQuotationDetails($quotation_id)
    {
        $res = [];
        try{
            $quotation = Quotation::with(['staff', 'customer', 'quotation_item','quotation_item.quotation_item_image'=>function($q) {
                    $q->first();
                }, 'quotation_item.gold_color', 'quotation_loose_piece', 
                'quotation_item.jewellery:id,drawing_image', 
                'quotation_item.jewellery.images'=>function($q){
                    $q->select('id', 'jewellery_id', 'image')->orderBY('id')->limit(1);
                }])->withSum('quotation_item','sub_total')->addSelect(DB::raw("'-' as gst_total"))->addSelect(DB::raw("'-' as grand_total"))->findOrFail($quotation_id);

            $quotation->quotation_item_sum_sub_total = $quotation->quotation_item_sum_sub_total ?? 0;
            $quotation->gst_total = calculateGST($quotation->quotation_item_sum_sub_total);
            $quotation->grand_total = (float) ($quotation->gst_total + $quotation->quotation_item_sum_sub_total);

            $res['status'] = 1;
            $res['data'] = $quotation;
            $res['message'] = 'Quotation found!';
        } catch(\Exception $err){
            Log::error('Error in getQuotationDetails on QuotationComponent :'.$err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return $res;
    }

}
