<?php

namespace App\Http\Controllers\Components;

// use App\Http\Controllers\Components\QuotationComponent;
// use App\Http\Controllers\Components\InvoiceComponent;
use App\Models\Quotation;
use App\Models\Invoice;
use PDF;
use Log;
use DB;

Class PDFComponent
{
    function __construct()
    {
        // $this->QuotationComponent = new QuotationComponent();
        // $this->InvoiceComponent = new InvoiceComponent();
    }

    public function generateQuotationPDF($quotation) 
    { 
        $res = [];
        try{
            // share data to view
            view()->share('admin.quotations.pdf.quotation_pdf', $quotation);
            $pdf = PDF::loadView('admin.quotations.pdf.quotation_pdf', ['quotation' => $quotation])->setOptions(['defaultFont' => 'sans-serif', 'isRemoteEnabled' => true]);

            $fileName = 'Quotation-'.$quotation->quotation_no.'-'.time().'.pdf';
            $filePath = public_path(Quotation::PDF_PATH.'/'.$fileName);
            $headers = ['Content-Type: application/pdf'];
                
            $res['status'] = 1;
            $res['message'] = 'Quotation PDF downloaded successfully!';
            $res['data'] = $pdf->download($filePath, $fileName, $headers);
        } catch (\Exception $err) {
            Log::error('Error in generateQuotationPDF on PDFComponent :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
            $res['data'] = null; 
        }
        return $res;
    }

    public function generateOrderVoucherPDF($quotation) 
    { 
        $res = [];
        try{
            // share data to view
            view()->share('admin.quotations.pdf.order_voucher_pdf', $quotation);
            $pdf = PDF::loadView('admin.quotations.pdf.order_voucher_pdf', ['quotation' => $quotation])->setOptions(['defaultFont' => 'sans-serif', 'isRemoteEnabled' => true]);
        
            $fileName = 'OrderVoucher-'.$quotation->quotation_no.'-'.time().'.pdf';
            $filePath = public_path(Quotation::PDF_PATH.'/'.$fileName);
            $headers = ['Content-Type: application/pdf'];
                
            $res['status'] = 1;
            $res['message'] = 'Order Voucher PDF downloaded successfully!';
            $res['data'] = $pdf->download($filePath, $fileName, $headers);
        } catch (\Exception $err) {
            Log::error('Error in generateOrderVoucherPDF on PDFComponent :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
            $res['data'] = null; 
        }
        return $res;
    }

    public function generateInvoicePDF($invoice) 
    { 
        $res = [];
        try{
            // share data to view
            view()->share('frontend.invoices.pdf.invoice_pdf', $invoice);
            $pdf = PDF::loadView('admin.invoices.pdf.invoice_pdf', ['invoice' => $invoice])->setOptions(['defaultFont' => 'sans-serif', 'isRemoteEnabled' => true]); 

            $fileName = 'Invoice-'.$invoice->invoice_no.'-'.time().'.pdf';
            $filePath = public_path(Invoice::PDF_PATH.'/'.$fileName);
            $headers = ['Content-Type: application/pdf'];
                
            $res['status'] = 1;
            $res['message'] = 'PDF downloaded successfully!';
            $res['data'] = $pdf->download($filePath, $fileName, $headers);
        } catch (\Exception $err) {
            Log::error('Error in generateInvoicePDF on PDFComponent :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
            $res['data'] = null; 
        }
        return $res;
    }

    // public function sendQuotationAndInvoiceEmailPDF($quotation_id, $invoice_id)
    // {
    //     $res = [];
    //     // try{
    //         // dd($request);

    //         $quotationRes = $this->QuotationComponent->getQuotationDetails($quotation_id);
    //         if($quotationRes['status'] == 1){
    //             $quotation = $quotationRes['data'];

    //             $quotationPDFRes = $this->PDFComponent->generateQuotationPDF($quotation);
    //             if($quotationPDFRes['status'] == 1){
    //                 $quotationPDF = $quotationPDFRes['data'];
    //             }else{
    //                 return back()->with('error', $quotationPDFRes['message']);
    //             }

    //             // $orderVoucherPDFRes = $this->generateOrderVoucherPDF($quotation);
    //             $orderVoucherPDFRes = $this->PDFComponent->generateOrderVoucherPDF($quotation);
    //             if($orderVoucherPDFRes['status'] == 1){
    //                 $orderVoucherPDF = $orderVoucherPDFRes['data'];
    //             }else{
    //                 return back()->with('error', $orderVoucherPDFRes['message']);
    //             }
    //         }else{
    //             return back()->with('error', $quotationRes['message']);
    //         }
           
    //         $invoiceRes = $this->InvoiceComponent->getInvoiceDetails($invoice_id);
    //         if($invoiceRes['status'] == 1){
    //             $invoice = $invoiceRes['data'];

    //             $invoicePDFRes = $this->PDFComponent->generateInvoicePDF($invoice);
    //             if($invoicePDFRes['status'] == 1){
    //                 $invoicePDF = $invoicePDFRes['data'];
    //             }else{
    //                 return back()->with('error', $invoicePDFRes['message']);
    //             }
    //         }else{
    //             return back()->with('error', $invoiceRes['message']);
    //         }

    //         $mailData = [
    //             'name'    => $quotation->customer_name ?? $quotation->customer->fullname,
    //             'email'   => $quotation->customer_email ?? $quotation->customer->email,
    //             'message' => 'Attach with the quotation pdf, order voucher pdf and invoice pdf.',
    //             'quotationPDF'    => $quotationPDF,
    //             'orderVoucherPDF' => $orderVoucherPDF,
    //             'invoicePDF'      => $invoicePDF,
    //         ];

    //         Mail::to($mailData['email'])->send(new QuotationAndInvoicePDFMail($mailData)); 
      
    //         // return back()->with('success', 'Quotation Mail sent successfully!');
    //         $res['status'] = 1;
    //         $res['message'] = 'Quotation, Order Voucher and Invoice PDF Mail sent successfully!';
    //     // } catch (\Exception $err) {
    //     //     Log::error('Error in sendQuotationAndInvoiceEmailPDF on PDFComponent :' . $err->getMessage());
    //     //    // return back()->with('error', $err->getMessage());
    //           // $res['status'] = 0;
    //           // $res['message'] = $err->getMessage();
    //     // }
    //     return $res;
    // }


}
