<?php

namespace App\Http\Controllers\Components;
use App\Models\Quotation;
use App\Models\Job;
use File;

Class MultipleDropzoneComponent
{


    function storeImage($image, $imagePath, $tmpDirPath, $tableName)
    {
        try {
            if ($image) {
                if (!File::exists(public_path($imagePath))) {
                    File::makeDirectory(public_path($imagePath), 0755, true, true);
                }

                if (File::exists(public_path($tmpDirPath . 1 . '/' . $tableName . '/' . $image))) {
                    File::copy(public_path($tmpDirPath . 1 . '/' . $tableName) . '/' . $image, public_path($imagePath . '/' . $image));
                    $temp_path = public_path($tmpDirPath . 1 . '/' . $tableName) . '/' . $image;
                    File::delete($temp_path);
                }
            }
        } catch (\Exception $err) {
            Log::error('Error in storeImage on MultipleDropzoneComponent :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }



}