<?php

namespace App\Http\Controllers\Components;

use App\Models\Setting;
use Log;

class JobReviewCostCalComponent
{

    public function calculateCost($validated)
    {
        try {
            $setting = Setting::price_settings();
            $review_cost_data = [];
            $stockPrice = 0;
        
            if(isset($validated['qut'])){
                $stockJewelley =   collect($validated['qut']);
                $priceArr = $stockJewelley->map(function ($value, $keyy){
                    $coll = collect($value)->map(function ($val, $key){
                        $coll = collect($val)->map(function ($v, $k){
                            return (array_sum(array_column($v, 'price'))); 
                        });
                        return ($coll);
                    });
                    return ($coll);
                })->toArray();

                foreach($priceArr as $key=>$value){
                    foreach($value as $k=>$v){
                        $stockPrice = $v['jewelleries'];
                    }
                }
            }

            $sub_total = ($validated['gold_cost'] ?? 0) + ($validated['setting_cost'] ?? 0) + ($validated['backing_cost'] ?? 0) + ($validated['craftsmanship_cost'] ?? 0) + ($validated['polishing'] ?? 0) + $stockPrice; 
            $gst_percent = $setting['gst_percent'];
            $gst_amount = ($sub_total * $gst_percent) / 100;
            $total = $sub_total + $gst_amount;

            $review_cost_data['sub_total'] = $sub_total;
            $review_cost_data['gst_percent'] = $gst_percent;
            $review_cost_data['gst_amount'] = $gst_amount;
            $review_cost_data['total'] = $total;

            if ($review_cost_data) {
                $res['status'] = 1;
                $res['message'] = 'Calculate Cost successfully.';
                $res['data'] = $review_cost_data;
            } else {
                $res['status'] = 0;
                $res['message'] = 'Unable to Calculate Cost!';
                $res['data'] = null;
            }
        } catch (\Exception $err) {
            Log::error('Error in calculateCost on JobReviewCostCalComponent :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return $res;

    }


}
