<?php

namespace App\Http\Controllers\Components;

use App\Models\Invoice;
use Log;
use DB;

Class InvoiceComponent
{
    public function getInvoiceDetails($invoice_id)
    {
        $res = [];
        try{
            $invoice = Invoice::with(['staff', 'customer', 'quotation', 'invoice_item', 'invoice_item.quotation_item.quotation_item_image'=>function($q) {
                    $q->first();
                }, 'invoice_item.gold_color', 
                'invoice_item.jewellery:id,drawing_image', 
                'invoice_item.jewellery.images'=>function($q){
                    $q->select('id', 'jewellery_id', 'image')->orderBY('id')->limit(1);
                }, 'invoice_item.quotation_item.quotation_loose_piece'])->withSum('invoice_item','sub_total')->addSelect(DB::raw("'-' as gst_total"))->addSelect(DB::raw("'-' as grand_total"))->findOrFail($invoice_id);
            $invoice->invoice_item_sum_sub_total = $invoice->invoice_item_sum_sub_total ?? 0;
            $invoice->gst_total = calculateGST($invoice->invoice_item_sum_sub_total);
            $invoice->grand_total = (float) ($invoice->gst_total + $invoice->invoice_item_sum_sub_total);

            $res['status'] = 1;
            $res['data'] = $invoice;
            $res['message'] = 'Invoice found!';
        } catch(\Exception $err){
            Log::error('Error in getInvoiceDetails on InvoiceComponent :'.$err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return $res;
    }




}
