<?php

namespace App\Http\Controllers\Components;

use App\Mail\RegisterMail;
use App\Models\User;
use Mail;
use Log;
use DB;

Class CustomerComponent
{
    const JOB = 'Job';
    const JEWELLERY = 'Jewellery';
    const QUOTATION = 'Quotation';
    const CONSIGNMENT = 'Consignment';

    const COUNTRY_CODE = '+65';

    const MODELS_ARR = [ self::JOB, self::JEWELLERY, self::QUOTATION ];

    public function addOrupdateCustomer($data, $modelName=null)
    {
        $res = [];
        DB::beginTransaction();
        try{
           if($data['customer_email']){
                $email_exist = User::where('email', $data['customer_email'])->first();

                if(strpos($data['customer_phone'], ' ') !== false){
                    $phoneNo_with_code = explode(' ', $data['customer_phone']);
                    $country_code = (count($phoneNo_with_code) > 1) ? $phoneNo_with_code[0] : null;
                    $phone_no = (count($phoneNo_with_code) > 1) ? $phoneNo_with_code[1] : $phoneNo_with_code[0];
                }elseif(strpos($data['customer_phone'], '-') !== false){
                    $phoneNo_with_code = explode('-', $data['customer_phone']);
                    $country_code = (count($phoneNo_with_code) > 1) ? $phoneNo_with_code[0] : null;
                    $phone_no = (count($phoneNo_with_code) > 1) ? $phoneNo_with_code[1] : $phoneNo_with_code[0];
                }else{
                    $country_code = null;
                    $phone_no = $data['customer_phone'];
                }

                $customer_data = [
                    'fullname'     => $data['customer_name'],
                    'email'        => $data['customer_email'],
                    'country_code' => $country_code,
                    'phone'        => $phone_no,
                ];

                if($email_exist){
                    if($email_exist->phone != $phone_no){
                        $email_exist->fill($customer_data);
                        $email_exist->save();

                        if($email_exist->wasChanged()){
                            DB::commit();
                            $res['status'] = 1;
                            $res['message'] = 'Customer details updated successfully.';
                            $res['data'] = $email_exist->id;
                        }else{
                            $res['status'] = 0;
                            $res['message'] = 'Unable to update customer details!';
                            $res['data'] = null;
                        }
                    }else{
                        DB::commit();
                        $res['status'] = 1;
                        $res['message'] = 'Customer already exists.';
                        $res['data'] = $email_exist->id;
                    }
                }else{
                    $user = new User();
                    $user->fill($customer_data);
                    $user->save();

                    if($user->exists()){
                        if(in_array($modelName, self::MODELS_ARR)){
                            $mailRes = $this->_sendRegistrationMail($data);
                            if($mailRes['status'] !== 1){
                                $res['status'] = $mailRes['status'];
                                $res['message'] = $mailRes['message'];
                                $res['data'] = $mailRes['data'];
                            }
                        }
                        DB::commit();
                        $res['status'] = 1;
                        $res['message'] = 'Customer registered successfully.';
                        $res['data'] = $user->id;
                    }else{
                        $res['status'] = 0;
                        $res['message'] = 'Unable to save customer details!';
                        $res['data'] = $user->id;
                    }
                }
            } else{
                DB::commit();
                $res['status'] = 0;
                $res['message'] = 'Unable to save customer details!';
                $res['data'] = null;
            }
        } catch(\Exception $err){
            DB::rollback();
            Log::error('Error in addOrupdateCustomer on CustomerComponent :'.$err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return $res;
    }

    public function _sendRegistrationMail($data)
    {
        $res = [];
        try{
            $user_data = [
                'Name' => $data['customer_name'],
                'Email' => $data['customer_email'],
                'Phone' => $data['customer_phone'],
            ];

            $maildata = [
                'name'      => $data['customer_name'],
                'title'     => "Welcome To Sancy ERP.",
                'message'   => "You have registered succssefully!",
                'user_data' => $user_data,
            ];

            Mail::to($data['customer_email'])->send(new RegisterMail($maildata));

            if( count(Mail::failures()) > 0 ) {
                $res['status'] = 0;
                $res['message'] = "Mail not sent!";
                $res['data'] = null;
            } else {
                $res['status'] = 1;
                $res['message'] = 'Mail sent successfully.';
                $res['data'] = $maildata;
            }
        }catch(\Exception $err){
            Log::error('Error in addOrupdateCustomer on CustomerComponent :'.$err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return $res;
    }


}
