<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Http\Requests\BuyersRequest;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }

    public function registerBuyer(Request $request)
    {
        try {

            $validator = \Validator::make($request->all(), [
                'name' => "required|string",
                'email' => "required|email|unique:users,email",
                'password' => "required|min:6",
                'password_confirmation'=> 'required','same:password',
                'phone' => "required|min:10|numeric",
            ]);
            if ($validator->fails())
            {
                return response()->json(['errors'=>$validator->errors(), 'status' => 0,]);
            }
            if ($validator->passes()) {
                DB::beginTransaction();
                $allData = $request->all();
                $allData['status'] = User::ACTIVE;
                $allData['role'] = User::BUYER;
                $allData['password'] = Hash::make($allData['password']);
                $buyer = User::create($allData);
                Auth::login($buyer);
                DB::commit();
                if($buyer){
                    return response()->json([
                        'message' => 'You have registered successfully !!',
                        'status' =>1,
                    ]);
                }
            }
        } catch (\Exception $e) {
            DB::rollback();
            Log::error('Error in registerBuyer on RegisterController : ' . $e->getMessage());
        }
    }


}
