<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use http\Env\Response;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use App\Models\User;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/dashboard';  // RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        if(Auth::guard('web')->check()){
            return redirect()->route('dashboard');
        } 
        $this->middleware('web')->except('logout');
    }

    public function showLoginForm()
    {  
        try {
            return view('home.index');
        } catch (\Exception $err) { 
            Log::error('Error in showLoginForm on Front\LoginController :' . $err->getMessage());
            return redirect()->back()->with('error',$err->getMessage());  
        }
    }

    public function login(Request $request)
    {
        try {
            $this->validate($request, [
                'email' => 'required|email',
                'password' => 'required',
            ]); 

            $input = $request->all();
            if (auth()->guard('web')->attempt(array('email' => $input['email'], 'password' => $input['password']))) {
                return redirect()->route('dashboard')->with('success', 'Hi '.Auth::guard('web')->user()->fullname.'. You have logged in successfully !!');
            }else{
                return redirect()->back()->with('error','Invalid Email or Password');
            } 
        } catch (\Exception $err) { 
            Log::error('Error in login on Front\LoginController :' . $err->getMessage());
            return redirect()->back()->with('error',$err->getMessage());  
        }
    }

    protected function loggedOut(Request $request)
    {
        try{
             Auth::guard('web')->logout(); // commented to solve error:when logout front, it automatically logout admin

            return redirect('/login');
            // return redirect()->route('login');

            // return redirect()->route('home')->with(['success'=>'You have been logged out successfully']);
        } catch (\Exception $err) { 
            Log::error('Error in loggedOut on Front\LoginController :' . $err->getMessage());
            return redirect()->back()->with('error',$err->getMessage());  
        }
    }

    /**
     * Get the guard to be used during authentication.
     *
     * @return \Illuminate\Contracts\Auth\StatefulGuard
     */
    protected function guard()
    {
        return Auth::guard();
    }


}

