<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Jewellery;
use Log;

class RfidController extends Controller
{

    public function getItemCount(Request $request)
    {
        try {
            $count = Jewellery::count(); 
            $message = "Success";
            $data['itemCount'] = $count;  
            return $this->sendResponse('SUCCESS', $message,$data);
        } catch (\Exception $err) {
            Log::error('Error in getItemData on ApiController :' . $err->getMessage()); 
            return $this->sendResponse('error', $err->getMessage());
        }
    }

    public function getItemData(Request $request)
    { 
        try {
            $datas = Jewellery::with('first_image')->get()->toArray(); 
            $datas = collect($datas);
            $datas = $datas->map(function ($name) {
                $name['set_image_name'] = $name['first_image']['image_url'] ?? getDefaultImage();
                unset($name['first_image']); 
                return $name;
            });
            $message = "Success";
            $data['count'] = $datas->count(); 
            $this->data = $datas; 
            
            return $this->sendResponse('SUCCESS', $message, $data);
        } catch (\Exception $err) {
            Log::error('Error in getItemData on ApiController :' . $err->getMessage()); 
            return $this->sendResponse('error', $err->getMessage());
        }
    }
    
}
