<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Builder;
use App\Http\Controllers\Controller;
use Illuminate\Support\Collection;
use App\Http\Requests\Quotations\QuotationItemsRequest;
use App\Models\Jewellery;
use App\Models\Quotation;
use App\Models\Consignment;
use App\Models\User;
use App\Models\Job;
use Validator;
use File;
use Log;
use DB;

class AjaxController extends Controller
{

    public function getJewelleryByItemCode(Request $request,$module)
    {
        try {
            $res = [];
            $validator = Validator::make($request->all(), [
                'item_code' => 'required',
            ]);
            if ($validator->fails()) {
                $res['status'] = 0;
                $res['errors'] = $validator->errors();
            }
            if ($validator->passes()) {
                $buttonIndex = $request->button_index;
                $jewellery = Jewellery::getJewelleryByItemCode($request->item_code);
                if ($jewellery) {
                    $data  = $jewellery;
                    $render_Button = view("frontend.$module.button_render", compact('buttonIndex'))->render();
                    $renderShowItem = view("frontend.$module.show_item_render", compact(['request','data']))->render();
                    $res['status'] = 1;
                    $res['message'] = 'Fetch jewellery by Item Code successfully!';
                    $res['data'] = $jewellery;
                    $res['render_button'] = $render_Button;
                    $res['show_item'] = $renderShowItem;
                } else {
                    $res['status'] = 0;
                    $res['message'] = 'Item not found!';
                }
            }
        } catch (\Exception $err) {
            Log::error('Error in getJewelleryByItemCode on Frontend/AjaxController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return response()->json($res);
    }

    public function getJobByItemCode(Request $request,$module)
    {
        try {
            $res = [];
            $validator = \Illuminate\Support\Facades\Validator::make($request->all(), [
                'item_code' => 'required',
            ]);

            if ($validator->fails()) {
                $res['status'] = 0;
                $res['errors'] = $validator->errors();
            }

            if ($validator->passes()) {
                $buttonIndex = $request->button_index;
                $job = Job::getJobByItemCode($request->item_code);
                if ($job) {
                    $data = $job ;
                    $render_Button = view("frontend.$module.button_render", compact('buttonIndex'))->render();
                    $renderShowItem = view("frontend.$module.show_item_render", compact(['request','data']))->render();
                    $res['status'] = 1;
                    $res['message'] = 'Fetch job by Item Code successfully!';
                    $res['data'] = $job;
                    $res['render_button'] = $render_Button;
                    $res['show_item'] = $renderShowItem;
                } else {
                    $res['status'] = 0;
                    $res['message'] = 'Item not found!';
                }
            }
        } catch (\Exception $err) {
            Log::error('Error in getJobByItemCode on Frontend/AjaxController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return response()->json($res);
    }

    public function bespokeReairData(QuotationItemsRequest $request,$module)
    {
        try {
            $buttonIndex = $request->button_index;
            if ($buttonIndex || $buttonIndex== 0) {
                $render_Button = view("frontend.$module.button_render", compact('buttonIndex'))->render();
                $renderShowItem = view("frontend.$module.show_bes_rep_render", compact(['request']))->render();
                $res['status'] = 1;
                $res['message'] = 'Fetch Item Code successfully!';
                $res['render_button'] = $render_Button;
                $res['show_item'] = $renderShowItem;
            } else {
                $res['status'] = 0;
                $res['message'] = 'Item not found!';
            }
        } catch (\Exception $err) {
            Log::error('Error in bespokeReairData on Frontend/AjaxController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return response()->json($res);
    }

    public function getUserPhoneList(Request $request)
    {
        try{
            $phone= explode(" ",$request->q);
            if(isset($phone[1])){
                $search=$phone[1];
            }else{
                $search=$phone[0];
            }

            $all_data = User::selectRaw("email,fullname, concat(COALESCE(`country_code`,''),' ', phone) as phone")->where('phone', 'LIKE', $search . '%')->where('status',User::ACTIVE)->distinct()->get()->take(25);

            $data = [];
            foreach($all_data as $key => $value){
                $data[$key]['value']=$value->phone;
                $data[$key]['lable']=$value->phone;
                $data[$key]['fullname']=$value->fullname;
                $data[$key]['email']=$value->email;
            }
        } catch (\Exception $err) {
            Log::error('Error in getUserPhoneList on Frontend/AjaxController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return response()->json($data);
    }

    public function getItemGlobalSearch(Request $request)
    {
        $data = [];
        try{
            $all_data = getDetailsFromDbUsingCode($request);

            foreach($all_data as $key => $value){
                $data[$key]['value']=$value->lable;
                $data[$key]['lable']=$value->lable;
                $data[$key]['table_prefix']=$value->table_prefix;
                $data[$key]['id']=$value->value;
            }
        } catch (\Exception $err) {
            Log::error('Error in getItemGlobalSearch on Frontend/AjaxController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return response()->json($data);
    }

    function ajaxDropzoneStoreTmpImage(Request $request)
    {
        try {
            $image = $request->file('file');
            $tableName = $request->table;
            $originalName = $image->getClientOriginalName();
            $imageName = $tableName . time() . rand(0, 9999) . $originalName;

            if(!empty($tableName) && $tableName== Quotation::TABLENAME ){
                $temPathDir = Quotation::TEMP_PATH;
            }

             if(!empty($tableName) && $tableName== Job::TABLENAME ){
                $temPathDir = Job::TEMP_PATH;
            }

            if (!File::exists(public_path($temPathDir))) {
                File::makeDirectory(public_path($temPathDir. 1 . '/'.$tableName), 0755, true, true);
            }
            $image = $image->move(public_path($temPathDir . 1 . '/'.$tableName), $imageName);

            return response()->json([
                'status' => 1,
                'file' => $imageName,
                'message' => "Image Upoload Successfully!"
            ]);
        } catch (\Exception $err) {
            Log::error('Error in ajaxStoreImage on MultipleDropzoneComponent :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function getJewelleryItemCodeList(Request $request)
    {
        $search  = $request->itemcode;
        // $all_data = [];
        $data = [];

        $jewellery_data = Jewellery::with(['review_cost'])->where('item_code', 'LIKE', $search . '%')->where('status',Jewellery::ACTIVE)->whereHas('review_cost', function($q)
        {
          $q->where('total','!=', 0);
        })->get()->take(25);

        $consignment_data = Consignment::with(['consignment_item','consignment_review_cost'])->where('consignment_no', 'LIKE', $search . '%')->get()->take(25);

        if(!empty($jewellery_data)){
            foreach($jewellery_data as $key => $value){
                $data[$key]['value']=$value['item_code'];
                $data[$key]['lable']=$value['item_code'];
                $data[$key]['weight']= 1;
                $data[$key]['unit_price']= (float)$value['review_cost']['sub_total'];
                $data[$key]['price']= (float)1 * $value['review_cost']['sub_total'];
            }
        }
        if(!empty($consignment_data)){
            foreach($consignment_data as $key => $value){
                $data[$key]['value']=$value['consignment_no'];
                $data[$key]['lable']=$value['consignment_no'];
                $data[$key]['weight']=(float)$value['consignment_item']['weight'];
                $data[$key]['unit_price']= (float)$value['consignment_item']['unit_price'];
                $data[$key]['price']= (float)$value['consignment_item']['total_price'];
            }
        }
        return response()->json($data);
    }


}
