<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Admin\WorksmithsRequest;
use App\Http\Controllers\Components\SingleDropzoneComponent;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\RegisterMail;
use App\Models\Admin;
use App\Models\Role;
use File;
use Log;
use DB;

class WorksmithControllerOld extends Controller
{

    function __construct(SingleDropzoneComponent $singleDropzone)
    {
        $this->singleDropzone = $singleDropzone;

    }
    public function index(Request $request)
    {
        try {
            $role_id = Role::roleByname(Role::WORKSMITH);
            $records = Admin::where('role_id', $role_id)->sortable(['id' => 'desc']);
            if ($request->query('search')) {
                $records = $records->where(function ($q) use ($request) {
                    $q->where('fullname', 'LIKE', '%' . $request->query('search') . '%');
                    $q->orWhere('username', 'LIKE', '%' . $request->query('search') . '%');
                    $q->orWhere('email', 'LIKE', '%' . $request->query('search') . '%');
                    $q->orWhere('phone', 'LIKE', '%' . $request->query('search') . '%');
                });
            }

            $records = $records->paginate(($request->query('limit') ? $request->query('limit') : env('PAGINATION_LIMIT')));
            return view('admin.worksmiths.index', compact('records'));
        } catch (\Exception $err) {
            Log::error('Error in index on WorksmithController :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function create()
    {

        try {
            $record = new Admin();
            return view('admin.worksmiths.create', compact('record'));
        } catch (\Exception $err) {
            Log::error('Error in create on WorksmithController :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function store(WorksmithsRequest $request)
    {
        DB::beginTransaction();
        try {
            $validated = $request->validated();

            if (!empty($validated['image'])) {
                $imagePath = Admin::IMAGE_PATH;
                $tmpDirPath = Admin::TEMP_PATH;
                $tablename = Admin::TABLENAME;
                $this->singleDropzone->storeImage($validated, $imagePath, $tmpDirPath, $tablename);
            }

            $phoneNo_with_code = explode(' ', $validated['phone']);
            $country_code = (count($phoneNo_with_code) > 1) ? $phoneNo_with_code[0] : null;
            $phone_no = (count($phoneNo_with_code) > 1) ? $phoneNo_with_code[1] : $phoneNo_with_code[0];
            $validated['dob'] = !empty($validated['dob']) ? date('Y-m-d', strtotime($validated['dob'])) : null;
            $validated['country_code'] = $country_code;
            $validated['phone'] = $phone_no;
            $validated['status'] = Admin::ACTIVE;
            $worksmith = Admin::create($validated);


            DB::commit();
            return redirect()->route('admin.worksmiths.index')->with(['success' => 'Worksmith added successfully!']);
        } catch (\Exception $err) {
            DB::rollback();
            Log::error('Error in store on WorksmithController :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }


    public function edit($id)
    {
        try {
            $record = Admin::findOrFail($id);
            return view('admin.worksmiths.edit', compact('record'));
        } catch (\Exception $err) {
            Log::error('Error in edit on WorksmithController :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function update(WorksmithsRequest $request, $id)
    {

        $validated = $request->validated();
        $worksmith = Admin::findOrFail($id);
        $imagePath = Admin::IMAGE_PATH;
        $tmpDirPath = Admin::TEMP_PATH;
        $tablename = Admin::TABLENAME;
        $validated['image'] = $this->singleDropzone->updateImage($validated, $worksmith, $imagePath, $tmpDirPath, $tablename);

        $phoneNo_with_code = explode(' ', $validated['phone']);
        $country_code = (count($phoneNo_with_code) > 1) ? $phoneNo_with_code[0] : null;
        $phone_no = (count($phoneNo_with_code) > 1) ? $phoneNo_with_code[1] : $phoneNo_with_code[0];
        $validated['dob'] = !empty($validated['dob']) ? date('Y-m-d', strtotime($validated['dob'])) : null;
        $validated['country_code'] = $country_code;
        $validated['phone'] = $phone_no;

        $worksmith->fill($validated);
        $worksmith->save();
        return redirect()->route('admin.worksmiths.index')->with(['success' => 'Worksmith updated successfully!']);
    }


    public function destroy($id)
    {
        try {
            $record = Admin::findOrFail($id);
            if ($record->delete()) {
                if ($record->image) {
                    $imagePath =   Admin::IMAGE_PATH;
                    $this->singleDropzone->deleteImage($record,$imagePath);
                }
                return back()->with(['success' => 'Worksmith deleted successfully!']);
            } else {
                return back()->with(['error' => 'Unable to delete this record.']);
            }
        } catch (\Exception $err) {
            Log::error('Error in destroy on WorksmithController :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }
}
