<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\TypesRequest;
use Illuminate\Http\Request;
use App\Models\Type;
use Log;

class TypesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try{
            $records = Type::sortable(['id' => 'desc']);

            if($request->query('search')){
                $records = $records->where(function($q) use ($request) {
                    $q->where('name','LIKE','%'.$request->query('search').'%');
                    $search_array = explode('/',$request->query('search'));
                    if(count($search_array) !== 1){
                        [$search_array[0],$search_array[1]] =  [$search_array[1],$search_array[0]];
                        $new_date = implode('/',$search_array);
                        $q->orWhere('created_at','LIKE','%'.date('Y-m-d',strtotime($new_date)).'%');
                    }
                });
            }

            if(($request->query('from_date')) || ($request->query('to_date')) ){
                $from_date = date('Y-m-d',strtotime($request->query('from_date')));
                
                $end_date  = $request->query('to_date') ? date('Y-m-d',strtotime($request->query('to_date'))) : date('Y-m-d');
                $records = $records->whereBetween('created_at',[$from_date,$end_date]);   
            }

            $records = $records->paginate(($request->query('limit') ? $request->query('limit'):env('PAGINATION_LIMIT') ));
            return view('admin.types.index',  compact('records'));
        } catch(\Exception $err){
            Log::error('Error in index on TypesController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        } 
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try{
            $record = new Type; 
            return view('admin.types.create', compact('record'));
        } catch(\Exception $err){
            Log::error('Error in create on TypesController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        } 
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(TypesRequest $request)
    {
        try {
            $validated = $request->validated();
            $type = Type::create($validated);
            return redirect()->route('admin.types.index')->with(['success'=>'Type added successfully.']);   
        } catch(\Exception $err){
            Log::error('Error in store on TypesController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($type_id)
    {
        try {
            $record = Type::findOrFail($type_id);
            return view('admin.types.edit')->with(compact('record'));
        } catch(\Exception $err){
            Log::error('Error in edit on TypesController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(TypesRequest $request, $type_id)
    {
        try {
            $validated = $request->validated();

            $type = Type::findOrFail($type_id);
            $type->fill($validated);
            $type->save();
        
            return redirect()->route('admin.types.index')->with(['success'=>'Type updated successfully.']);  
        } catch(\Exception $err){
            Log::error('Error in update on TypesController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($type_id)
    {
        try {
            $record = Type::findOrFail($type_id);
        
            if($record->delete()){
                return back()->with(['success'=>'Type deleted successfully.']);
            }else {
                return back()->with(['error'=>'Unable to delete this record.']);
            }
        } catch(\Exception $err){
            Log::error('Error in destroy on TypesController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function changeStatus(Request $request)
    {
        try{
            $record = Type::findOrFail($request->id);
            $record->status = $request->status;
            if($record->save()){
                $error = 0;
                $message ='Status changed to <strong>'.$record->status.'</strong>.';
            } else {
                $error = 1;
                $message ='Unable to change status.';
            }
            return response()->json([
                'error' => $error,
                'message' => $message
            ]);
        } catch(\Exception $err){
            Log::error('Error in changeStatus on TypesController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }
}
