<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\SizesRequest;
use Illuminate\Http\Request;
use App\Models\Size;
use Log;

class SizesController extends Controller
{
    public function index(Request $request){
        try{
            $records = Size::sortable(['id'=>'desc']);
            if($request->query('search')){

            	$records = $records->where(function($q) use ($request){
                    $q->where('name','LIKE','%'.$request->query('search').'%');
                    $search_array = explode('/',$request->query('search'));
                    if(count($search_array) !== 1){
                        [$search_array[0],$search_array[1]] =  [$search_array[1],$search_array[0]];
                        $new_date = implode('/',$search_array);
                        $q->orWhere('created_at','LIKE','%'.date('Y-m-d',strtotime($new_date)).'%');
                    }
                    $q->orWhereHas('category',function($q) use ($request){
                        $q->where('name','LIKE','%'.$request->query('search').'%');
                    });
            	});
            }

            if(($request->query('from_date')) || ($request->query('to_date')) ){
                $from_date = date('Y-m-d',strtotime($request->query('from_date')));
                
                $end_date  = $request->query('to_date') ? date('Y-m-d',strtotime($request->query('to_date'))) : date('Y-m-d');
                $records = $records->whereBetween('created_at',[$from_date,$end_date]);    
            }

            if($request->query('category_id')){
                $records = $records->where(function($q) use ($request){
                    $q->where('category_id',$request->query('category_id'));
                });
            }

            $records = $records->paginate( ($request->query('limit')?$request->query('limit'):env('PAGINATION_LIMIT')) );
            return view('admin.sizes.index', compact('records'));
        }catch(\Exception $err){
        	Log::error('Error in index on SizesController :'.$err->getMessage());
        	return back()->with('error',$err->getMessage());
        }
    }

    public function create()
    {
    	try{
            $record = new Size;
            return view('admin.sizes.create', compact('record'));
    	}catch(\Exception $err){
    		Log::error('Error in create on SizesController :'.$err->getMessage());
    		return back()->with('error',$err->getMessage());
    	}
    }

    public function store(SizesRequest $request)
    {
    	try{
            $validated = $request->validated();
            $size = Size::create($validated);
            return redirect()->route('admin.sizes.index')->with(['success'=>'Size added successfully.']);
    	}catch(\Exception $err){
    		Log::error('Error in store on SizesController :'.$err->getMessage());
    		return back()->with('error',$err->getMessage());
    	}
    }

    public function edit($size_id)
    {
    	try{
    		$record = Size::findOrFail($size_id);
    		return view('admin/sizes.edit', compact('record'));
    	}catch(\Exception $err){
    		Log::error('Error in edit on SizesController :'.$err->getMessage());
    		return back()->with('error',$err->getMessage());
    	}
    }

    public function update(SizesRequest $request,$size_id)
    {
    	try{
            $validated = $request->validated();
            $size = Size::findOrFail($size_id);
            $size->fill($validated);
            $size->save();
            return redirect()->route('admin.sizes.index')->with(['success'=>'Size updated successfully.']);
    	}catch(\Exception $err){
    		Log::error('Error in update on SizesController :'.$err->getMessage());
    		return back()->with('error',$err->getMessage());
    	}
    }

    public function destroy($size_id)
    {
    	try {
            $record = Size::findOrFail($size_id);
        
            if($record->delete()){
                return back()->with(['success'=>'Size deleted successfully.']);
            }else {
                return back()->with(['error'=>'Unable to delete this record.']);
            }
        } catch(\Exception $err){
            Log::error('Error in destroy on SizesController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function changeStatus(Request $request)
    {
        try{
            $record = Size::findOrFail($request->id);
            $record->status = $request->status;
            if($record->save()){
                $error = 0;
                $message ='Status changed to <strong>'.$record->status.'</strong>.';
            } else {
                $error = 1;
                $message ='Unable to change status.';
            }
            return response()->json([
                'error' => $error,
                'message' => $message
            ]);
        } catch(\Exception $err){
            Log::error('Error in changeStatus on SizesController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }
}
