<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Admin\ShopSettingsRequest;
use App\Http\Requests\Admin\PriceSettingsRequest;
use App\Models\Setting;
use Log;

class SettingsController extends Controller
{

    public function shopSettings()
    {
        try{
            $records = Setting::where('group', 'like', 'Shop_Settings')->get()->toArray();
            return view('admin.settings.shop_settings',  compact('records'));
        } catch(\Exception $err){
            Log::error('Error in shopSettings on SettingsController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function updateShopSettings(ShopSettingsRequest $request)
    {
        try{
            $validated = $request->validated();
            foreach($validated as $key=>$value){
                Setting::where('key', $key)->update(['value' => $value]);
            }
            if(auth()->user()->hasPermissionTo('setting-shopSetting'))
            {
                return redirect()->route('admin.settings.shopSettings')->with(['success'=>'Shop Settings updated successfully!']);
            } else{
            return redirect()->route('admin.dashboard.index')->with('success', 'Shop Settings updated successfully!');
            }
        } catch(\Exception $err){
            Log::error('Error in updateShopSettings on SettingsController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function priceSettings()
    {
        try{
            $records = Setting::where('group', 'like', 'Price_Settings')->get();
            return view('admin.settings.price_settings',  compact('records'));
        } catch(\Exception $err){
            Log::error('Error in priceSettings on SettingsController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function updatePriceSettings(PriceSettingsRequest $request)
    {
        try{
            $validated = $request->validated();
            foreach($validated as $key=>$value){
                Setting::where('key', $key)->update(['value' => $value]);
            }
            if(auth()->user()->hasPermissionTo('setting-priceSetting'))
            {
             return redirect()->route('admin.settings.priceSettings')->with(['success'=>'Price Settings updated successfully!']);
            } else{
             return redirect()->route('admin.dashboard.index')->with('success', 'Price Settings updated successfully!');
            }    
        } catch(\Exception $err){
            Log::error('Error in updatePriceSettings on SettingsController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }
  
}
