<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\CommonHelper;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\Jobs\TotalJobsExport;
use App\Exports\Jobs\CompletedJobsExport;
use App\Exports\Quotations\TotalQuotationsExport;
use App\Exports\Invoices\TotalInvoicesExport;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Admin\Jobs\JobExportsRequest;
use App\Http\Requests\Admin\Quotations\QuotationExportsRequest;
use App\Http\Requests\Admin\Invoices\InvoiceExportsRequest;
use App\Models\InvoiceItem;
use App\Models\Quotation;
use App\Models\Category;
use App\Models\Invoice;
use App\Models\User;
use App\Models\Job;
use Carbon\Carbon;
use Session;
use Log;
use DB;


class DashboardController extends Controller
{
    public function index(Request $request)
    {
        try{
            Session::put('locale', 'en');

            $monthlySales = Category::with(['invoice_item'=>function($q){
                $q->select('category_id' ,'created_at' ,DB::raw("(COUNT(*)) as count"),  DB::raw("MONTHNAME(created_at) as monthname"))
                    ->whereYear('created_at', date('Y'))
                    ->groupBy('monthname','category_id'); 
            }])->get(); 
            $monthlySales= $monthlySales->map(function ($item, $key) { 
                return ['name'=>($item['name']),'count'=>$item['invoice_item'][0]->count??0,'monthname'=>substr($item['invoice_item'][0]->monthname??'Jan', 0, 3),'created_at'=>$item['created_at']];
            });

            $dailySales = Category::with(['invoice_item'=>function($q){
                $q->select('category_id','created_at',DB::raw("(COUNT(*)) as count"),  DB::raw("DAYNAME(created_at) as dayname"))
                    ->whereYear('created_at', date('Y'))
                    ->groupBy('dayname','category_id'); 
            }])->get();

            $dailySales= $dailySales->map(function ($item, $key) { 
                return ['name'=>($item['name']),'count'=>$item['invoice_item'][0]->count??0,'dayname'=>substr($item['invoice_item'][0]->dayname??'Jan', 0, 3),'created_at'=>$item['created_at']];
            }); 

            $saleData = ['monthly' => $monthlySales, 'daily' => $dailySales];

            $monthlyQuotations = Quotation::select(DB::raw("(SUM(total)) as count"), DB::raw("MONTHNAME(created_at) as monthname"))
                ->whereYear('created_at', date('Y'))
                ->groupBy('monthname')
                ->get();

            $quotationMonthlyMappingRes = $this->_monthlyMapping($monthlyQuotations);
            if($quotationMonthlyMappingRes['status'] == 1){
                $monthlyQuotationColl = $quotationMonthlyMappingRes['data'];
            }else{
                $monthlyQuotationColl = null;
            }

            $dailyQuotations = Quotation::select(DB::raw("(SUM(total)) as count"), DB::raw("DAYNAME(created_at) as dayname"))
                ->whereYear('created_at', date('Y'))
                ->groupBy('dayname')
                ->get();

            $quotationDailyMappingRes = $this->_dailyMapping($dailyQuotations);
            if($quotationDailyMappingRes['status'] == 1){
                $dailyQuotationColl = $quotationDailyMappingRes['data'];
            }else{
                $dailyQuotationColl = null;
            }

            $quotationData = ['monthly' => $monthlyQuotationColl, 'daily' => $dailyQuotationColl];


            $monthlyInvoices = Invoice::select(DB::raw("(COUNT(*)) as count"), DB::raw("MONTHNAME(created_at) as monthname"))
                ->whereYear('created_at', date('Y'))
                ->groupBy('monthname')
                ->get();

            $invoiceMonthlyMappingRes = $this->_monthlyMapping($monthlyInvoices);
            if($invoiceMonthlyMappingRes['status'] == 1){
                $monthlyInvoiceColl = $invoiceMonthlyMappingRes['data'];
            }else{
                $monthlyInvoiceColl = null;
            }

            $dailyInvoices = Invoice::select(DB::raw("(COUNT(*)) as count"), DB::raw("DAYNAME(created_at) as dayname"))
                ->whereYear('created_at', date('Y'))
                ->groupBy('dayname')
                ->get();

            $invoiceDailyMappingRes = $this->_dailyMapping($dailyInvoices);
            if($invoiceDailyMappingRes['status'] == 1){
                $dailyInvoicesColl = $invoiceDailyMappingRes['data'];
            }else{
                $dailyInvoicesColl = null;
            }

            $invoiceData = ['monthly' => $monthlyInvoiceColl, 'daily' => $dailyInvoicesColl];

            $records = $this->getRecentInvoices($request);

            return view('admin.dashboard.index', compact('saleData', 'quotationData', 'invoiceData', 'records')); 
        }catch(\Exception $err){
            Log::error('Error in index on DashboardController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        } 
    }

    public function invoiceRender(Request $request)
    {
        try {
            $invoiceListings = $this->getRecentInvoices($request);
              
            $view = view('admin.dashboard.invoice-render')->with('invoiceListings', $invoiceListings)->render();
            return response()->json(['table'=>$view]);
        } catch (\Exception $err) {
            Log::error('Error in invoiceRender on DashboardController :' . $err->getMessage());
            return response()->json(['table'=>'']);
        }
    }

    // public function getRecentInvoices($request)
    // {
    //     try {
    //         // dd($request);
    //         $records = InvoiceItem::with(['invoice', 'invoice.quotation'])->sortable(['id' => 'desc']);

    //         if ($request->query('search')) {
    //             $records = $records->where(function ($q) use ($request) {

    //                 $q->where('item_code', 'like', '%' . $request->query('search') . '%');
    //                 $q->orwhere('type_name', 'like', '%' . $request->query('search') . '%');
    //                 $q->orwhereHas('gold_color', function ($query) use ($request) {
    //                     $query->where('name', 'like', '%' . $request->query('search') . '%');
    //                 });

    //                 $q->orwhereHas('invoice', function ($query) use ($request) {
    //                     $query->where('customer_name', 'like', '%' . $request->query('search') . '%');
    //                     $query->orwhere('customer_email', 'like', '%' . $request->query('search') . '%');
    //                     $query->orwhere('customer_phone', 'like', '%' . $request->query('search') . '%');
    //                 });

    //                 $q->orwhereHas('invoice.staff', function ($query) use ($request) {
    //                     $query->where('fullname', 'like', '%' . $request->query('search') . '%');
    //                     $query->orwhere('email', 'like', '%' . $request->query('search') . '%');
    //                     $query->orwhere('phone', 'like', '%' . $request->query('search') . '%');
    //                 });

    //                 $q->orwhereHas('invoice.customer', function ($query) use ($request) {
    //                     $query->where('fullname', 'like', '%' . $request->query('search') . '%');
    //                     $query->orwhere('email', 'like', '%' . $request->query('search') . '%');
    //                     $query->orwhere('phone', 'like', '%' . $request->query('search') . '%');
    //                 });
    //             });
    //         }

    //         if (($request->query('invoice_start_date')) || ($request->query('invoice_end_date'))) {
    //             $start_date = (!empty($request->invoice_start_date)) ? date('Y-m-d', strtotime($request->invoice_start_date)) : date('Y-m-d');
    //             $end_date = (!empty($request->invoice_end_date)) ? date('Y-m-d', strtotime($request->invoice_end_date)) : date('Y-m-d');
    //             $records = $records->whereBetween('created_at', [$start_date, $end_date]);
    //         }

    //         $records = $records->paginate(($request->query('limit') ? $request->query('limit') : env('PAGINATION_LIMIT')));
    //         return $records;
    //     } catch (\Exception $err) {
    //         Log::error('Error in getRecentInvoices on DashboardController :' . $err->getMessage());
    //         return back()->with('error', $err->getMessage());
    //     }
    // }

    public function getRecentInvoices($request)
    {
        try {
            $records = Invoice::with(['quotation', 'invoice_item'])->sortable(['id' => 'desc']);

            if (($request->query('invoice_start_date')) || ($request->query('invoice_end_date'))) {
                $start_date = (!empty($request->invoice_start_date)) ? date('Y-m-d', strtotime($request->invoice_start_date)) : date('Y-m-d');
                $end_date = (!empty($request->invoice_end_date)) ? date('Y-m-d', strtotime($request->invoice_end_date)) : date('Y-m-d');
                $records = $records->whereBetween('created_at', [$start_date, $end_date]);
            }

            $records = $records->paginate(($request->query('limit') ? $request->query('limit') : env('PAGINATION_LIMIT')));
            return $records;
        } catch (\Exception $err) {
            Log::error('Error in getRecentInvoices on DashboardController :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function exportTotalJobs(JobExportsRequest $request)
    {
        try {
            $validated = $request->validated();

            $filename = "total_jobs-" . time() . ".xlsx";

            $export = Excel::store(new TotalJobsExport($validated['start_date'], $validated['end_date']), $filename, 'public');
            if ($export) {
                $link = Storage::url("app/public/{$filename}"); // Downloads file in sancy_erp/storage/app/public/filename.xlsx

                $res['status'] = 1;
                // $res['title']   = self::TOAST_SUCCESS;
                $res['data'] = env('APP_URL') . $link;
                $res['message'] = "All Jobs exported successfully.";
            } else {
                $res['status'] = 0;
                // $res['title']   = self::TOAST_ACTION_FAILED;
                $res['data'] = null;
                $res['message'] = "Unable to export all jobs.";
            }
        } catch (\Exception $err) {
            Log::error('Error in exportTotalJobs on DashboardController :' . $err->getMessage());
            $res['status'] = 0;
            // $res['title']   = self::TOAST_ERROR;
            $res['data'] = null;
            $res['message'] = $err->getMessage();
        }
        return response()->json($res);
    }

    public function exportCompletedJobs(JobExportsRequest $request)
    {
        try {
            $validated = $request->validated();

            $filename = "completed_jobs-" . time() . ".xlsx";

            $export = Excel::store(new CompletedJobsExport($validated['start_date'], $validated['end_date']), $filename, 'public');
            if ($export) {
                $link = Storage::url("app/public/{$filename}"); // Downloads file in sancy_erp/storage/app/public/filename.xlsx

                $res['status'] = 1;
                // $res['title']   = self::TOAST_SUCCESS;
                $res['data'] = env('APP_URL') . $link;
                $res['message'] = "Completed Jobs exported successfully.";
            } else {
                $res['status'] = 0;
                // $res['title']   = self::TOAST_ACTION_FAILED;
                $res['data'] = null;
                $res['message'] = "Unable to export completed jobs.";
            }
        } catch (\Exception $err) {
            Log::error('Error in exportCompletedJobs on DashboardController :' . $err->getMessage());
            $res['status'] = 0;
            // $res['title']   = self::TOAST_ERROR;
            $res['data'] = null;
            $res['message'] = $err->getMessage();
        }
        return response()->json($res);
    }

    public function exportTotalQuotations(QuotationExportsRequest $request)
    {
        try {
            $validated = $request->validated();

            $filename = "total_quotations-" . time() . ".xlsx";

            $export = Excel::store(new TotalQuotationsExport($validated['start_date'], $validated['end_date']), $filename, 'public');
            if ($export) {
                $link = Storage::url("app/public/{$filename}"); // Downloads file in sancy_erp/storage/app/public/filename.xlsx

                $res['status'] = 1;
                // $res['title']   = self::TOAST_SUCCESS;
                $res['data'] = env('APP_URL') . $link;
                $res['message'] = "Total Quotations exported successfully.";
            } else {
                $res['status'] = 0;
                // $res['title']   = self::TOAST_ACTION_FAILED;
                $res['data'] = null;
                $res['message'] = "Unable to export total quotations.";
            }
        } catch (\Exception $err) {
            Log::error('Error in exportTotalQuotations on DashboardController :' . $err->getMessage());
            $res['status'] = 0;
            // $res['title']   = self::TOAST_ERROR;
            $res['data'] = null;
            $res['message'] = $err->getMessage();
        }
        return response()->json($res);
    }

    public function exportTotalInvoices(InvoiceExportsRequest $request)
    {
        try {
            $validated = $request->validated();

            $filename = "total_invoices-" . time() . ".xlsx";

            $export = Excel::store(new TotalInvoicesExport($validated['start_date'], $validated['end_date']), $filename, 'public');
            if ($export) {
                $link = Storage::url("app/public/{$filename}"); // Downloads file in sancy_erp/storage/app/public/filename.xlsx

                $res['status'] = 1;
                // $res['title']   = self::TOAST_SUCCESS;
                $res['data'] = env('APP_URL') . $link;
                $res['message'] = "Total Invoices exported successfully.";
            } else {
                $res['status'] = 0;
                // $res['title']   = self::TOAST_ACTION_FAILED;
                $res['data'] = null;
                $res['message'] = "Unable to export total invoices.";
            }
        } catch (\Exception $err) {
            Log::error('Error in exportTotalInvoices on DashboardController :' . $err->getMessage());
            $res['status'] = 0;
            // $res['title']   = self::TOAST_ERROR;
            $res['data'] = null;
            $res['message'] = $err->getMessage();
        }
        return response()->json($res);
    }

    public function _monthlyMapping($data)
    {
        $res = [];
        try {
            $collection = collect($data->toArray());
            $collection = $collection->map(function ($item, $key) {
                return ['monthname'=>substr($item['monthname'], 0, 3), 'count'=>$item['count']];
            });
            $collection = $collection->all();

            $res['status'] = 1;
            $res['message'] = 'Successful mapping!';
            $res['data'] = $collection;
        } catch (\Exception $err) {
            Log::error('Error in _monthlyMapping on DashboardController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
            $res['data'] = null;
        }
        return $res;
    }

    public function _dailyMapping($data)
    {
        $res = [];
        try {
            $collection = collect($data->toArray());
            $collection = $collection->map(function ($item, $key) {
                return ['dayname'=>substr($item['dayname'], 0, 3), 'count'=>$item['count']];
            });
            $collection = $collection->all();

            $res['status'] = 1;
            $res['message'] = 'Successful mapping!';
            $res['data'] = $collection;
        } catch (\Exception $err) {
            Log::error('Error in _dailyMapping on DashboardController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
            $res['data'] = null;
        }
        return $res;
    }
}
