<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Http\Request;
use App\Http\Requests\Register\RegisterBuyersRequest;
use App\Http\Requests\Register\RegisterSellersRequest;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Setting;
use App\Models\DiscountCoupon;
use Session;
use Auth;
use Log;
use DB;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    // protected $redirectTo = RouteServiceProvider::HOME;
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            // 'name' => ['required', 'string', 'max:255'],
            'firstname' => ['required', 'string', 'max:100'],
            'lastname' => ['required', 'string', 'max:100'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8'], //, 'confirmed'
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(Request $request) // array $data,  
    {
        try{
            //return 
            // dd('hi');

            // $request->validate([
            //     'firstname' => ['required', 'string', 'max:100'],
            //     'lastname' => ['required', 'string', 'max:100'],
            //     'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            //     'password' => ['required', 'string', 'min:8'], //, 'confirmed'
            // ]);
            // dd($request);

            $user = User::create([
                'is_admin' => User::ZERO,
                'user_type' => $request['user_type'],
                // 'name' => $data['name'], 
                'firstname' => $request['firstname'], // $data['name'],  // 
                'lastname' => $request['lastname'], // $data['name'],  // 
                'email' => $request['email'], // $data['email'], // 
                'password' => Hash::make($request['password']), // Hash::make($data['password'])
            ]);

            if($user->exists){
                Auth::loginUsingId($user->id);
                return redirect()->route('home')->with('success', 'Hi '.Auth::user()->firstname." ".Auth::user()->firstname.'. You have registered successfully !!');
            }else{
                return redirect()->route('home')->with('error', 'Something went wrong!!');
            }
        } catch(\Exception $err){
            Log::error('Error in create on RegisterController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }


    public function showRegisterBuyer($referer_id = null)
    {
        try{
            $record = new User();
            return view('auth.register.buyer',compact(['record','referer_id']));
        } catch(\Exception $err){
            Log::error('Error in showRegisterBuyer on RegisterController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function registerBuyer(RegisterBuyersRequest $request)
    {
        DB::beginTransaction();
        try{
            $validated=$request->validated();
            $allData = $request->validated();
            $allData['is_admin'] = User::ZERO;
            $allData['user_type'] = User::BUYER;
            $allData['password'] = Hash::make($validated['password']);
            $allData['request_for_approved'] = User::ZERO;
            $allData['approved_status'] = User::PENDING;

            if($request->referer_id !== null) {
                unset($allData['referer_id']);
                $referer_id = $request['referer_id'];
            }
            $buyer = User::create($allData);

            if($buyer->exists()) {
                //$buyer->sendEmailVerificationNotification();

                if(isset($referer_id)) {
                    $coupan_settings = Setting::where('group', 'like','Discount_Coupon_Settings')->pluck('value', 'key')->toArray();
                    $days = 30;

                    if($coupan_settings['referal'] == Setting::YES) {
                        if($coupan_settings['user_coupon_amount'] !== 0) {
                            $code = $this->codeGenerate();
                            $array = [
                                'coupon_code' => $code,
                                'amount' => $coupan_settings['user_coupon_amount'],
                                'type' => DiscountCoupon::SINGLE,
                                'created_by_id' => $referer_id,
                                'user_id' => $referer_id,
                                'created_by_type' => DiscountCoupon::USER,
                                'expiry_date' => date('Y-m-d H:i:s', strtotime(' + '.$days.' days')),
                                'status' => DiscountCoupon::ACTIVE,
                            ];
                            $user_coupon = DiscountCoupon::create($array);
                        }

                        if($coupan_settings['refered_coupon_amount'] !== 0) {
                            $code = $this->codeGenerate();
                            $arr = [
                                'coupon_code' => $code,
                                'amount' => $coupan_settings['refered_coupon_amount'],
                                'type' => DiscountCoupon::SINGLE,
                                'created_by_id' => $referer_id,
                                'user_id' => $buyer->id,
                                'created_by_type' => DiscountCoupon::USER,
                                'expiry_date' => date('Y-m-d H:i:s', strtotime(' + '.$days.' days')),
                                'status' => DiscountCoupon::ACTIVE,
                            ];
                            $refered_coupon = DiscountCoupon::create($arr);
                        }
                    }
                }

                if(Auth::loginUsingId($buyer->id)){
                    $session_count = \App\Models\Cart::where('user_id',$buyer->id)->count();
                    if($session_count > 0) {
                        $request->session()->put('cart_product_count', $session_count);
                    }else{
                        $request->session()->put('cart_product_count', 0);
                    }

                    DB::commit();
                    return redirect()->route('home')->with('success', 'Hi '.Auth::user()->firstname." ".Auth::user()->lastname.'. You have registered successfully !!');
                }else{
                    return redirect()->route('home')->with('success', 'You have registered successfully !!');
                }
            }else{
                return back()->with('error', 'Something went wrong. Try again.');
            }
        } catch(\Exception $err){
            DB::rollback();
            Log::error('Error in registerBuyer on RegisterController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function codeGenerate()
    {
        $code = '';

        while($code == ''){
            $length = 8;
            $pool = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $new_code = substr(str_shuffle(str_repeat($pool, 5)), 0, $length);
            $record = DiscountCoupon::withTrashed()->where('coupon_code',$new_code)->get();

            if(count($record) < 1){
                $code = $new_code;
            }
        } 
        return $code;
    }

    //Service Provider
    public function showRegisterSeller()
    {
        try{
            $record = new User();
            return view('auth.register.seller',compact('record'));
        } catch(\Exception $err){
            Log::error('Error in showRegisterSeller on RegisterController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function registerSeller(RegisterSellersRequest $request)
    {
        DB::beginTransaction();
        try{
            $validated=$request->validated();
            $allData = $request->validated();
            $allData['is_admin'] = User::ZERO;
            $allData['user_type'] = User::SELLER;
            $allData['password'] = Hash::make($validated['password']);
            $allData['request_for_approved'] = User::ONE;
            $allData['approved_status'] = User::APPROVED;
            $seller = User::create($allData);

            if($seller->exists()) {
                DB::commit();
            
                //$seller->sendEmailVerificationNotification();
                Auth::loginUsingId($seller->id);
                return redirect()->route('home')->with('success', 'Hi '.Auth::user()->name.'. You have registered successfully !!');
            }else{
                return back()->with('error', 'Something went wrong. Try again.');
            }
        } catch(\Exception $err){
            DB::rollback();
            Log::error('Error in registerSeller on RegisterController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }
}
