<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
Use App\Models\Jewellery;
use File;
use Auth;
use Log;


class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/admin/dashboard';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest:admin')->except('logout');
    }

    public function showLoginForm()
    {
        return view('admin.auth.login');
    }

    public function login(Request $request)
    {
        $input = $request->all();

        $this->validate($request, [
            'email' => 'required|email',
            'password' => 'required',
        ]);

        if(auth()->guard('admin')->attempt(array('email' => $input['email'], 'password' => $input['password'])))
        {
            $path = public_path(Jewellery::TEMP_PATH .Auth::guard('admin')->user()->id.'/jewelleries/');
            if (File::exists($path)) File::deleteDirectory($path);
            return redirect()->route('admin.dashboard.index')->with('success', 'Hi '.Auth::guard('admin')->user()->fullname.'. You have logged in successfully !!');
        }else{
            return redirect()->route('admin.login')->with('error', 'Invalid email or password.');
        }
    }


    protected function loggedOut(Request $request)
    {
         Auth::guard('admin')->logout();
        return redirect()->route('admin.login')->with(['success'=>"You have been logged out."]);
    }

    /**
     * Get the guard to be used during authentication.
     *
     * @return \Illuminate\Contracts\Auth\StatefulGuard
     */
    protected function guard()
    {
        return Auth::guard('admin');
    }
}
